import { ParamDateTime } from '../../data/common'
import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ExtraReportParameters } from '../../additional/ExtraReportParameters'
import { ReportFilterAttributes } from '../../additional/ReportFilterAttributes'
import BaseOpenAPIClient = require('../base-open-api-client');

type BaseReportAttributes = {
    RPT_ID: number,
    RPT_DN: string,
    RPT_TYPE: number,
    RPT_CREATED: string,
    RPT_MODIFIED: string,
    RPT_GROUP_ID: number,
    'RPT_EXTRA_DATA': ExtraReportParameters
}

type ReportAttributes = BaseReportAttributes & {
    RPT_FIELDS: any[],
    RPT_ORDER: {
        Name: string,
        Asc: boolean
    }[],
    RPT_SUMM_FIELDS: any[],
    RPT_SUMM_ORDER: {
        Name: string,
        Asc: boolean
    }[],
    RPT_TOTALS: any[],
    RPT_TIME_INTERVAL_TYPE: number,
    RPT_START_TIME: ParamDateTime,
    RPT_END_TIME: ParamDateTime,
    RPT_DAYS_BEFORE_CREATION: number,
    RPT_MAX_RECORDS: number,
    RPT_HOSTS: any[]
}

type StatParams = {
    KLSTS_Par_StatusReasonMask?: number,
    KLSTS_Par_Status?: number
} & Record<string, any>

export type StatsAttributes = {
    KLPPT_DASHBOARD: Record<string, any>, // https://support.kaspersky.com/help/KSC/13.1/KSCAPI/a00047.html
    KLSTS_Deployment: StatParams,
    KLSTS_Updates: StatParams,
    KLSTS_Protection: StatParams,
    KLSTS_FullScan: StatParams,
    KLSTS_Administration: StatParams,
    KLSTS_Events: StatParams
}

export type ReportManager = BaseOpenAPIClient & {
    EnumReports(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<BaseReportAttributes[]>,
    EnumReportTypes(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Pick<ReportAttributes, 'RPT_TYPE' | 'RPT_DN'>>,
    GetReportTypeDetailedInfo(lReportTypeId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ReportAttributes>,
    GetReportInfo(lReportId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ReportAttributes>,
    AddReport(data: Partial<ReportAttributes>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    UpdateReport({ lReportId, data }: {
        lReportId: number,
        data: Partial<ReportAttributes>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RemoveReport(lReportId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ExecuteReportAsync({ lReportId, pOptions }: {
        lReportId: number,
        pOptions: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    ExecuteReportAsyncGetData(strRequestId: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    ExecuteReportAsyncGetParsedData(strRequestId: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetDefaultReportInfo({ lReportType }: {
        lReportType: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ReportAttributes>,
    RequestStatisticsData(pRequestParams: Record<string, unknown>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    /**
     * @deprecated
     */
    GetStatisticsData(strRequestId: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<StatsAttributes>,
    ExecuteReportAsyncCancel({ strRequestId }: {
        strRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetConstantOutputForReportType({ lReportType, lXmlTargetType }: {
        lReportType: number,
        lXmlTargetType: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    CreateChartPNG({ pChartData, pOptions }: {
        pChartData: Record<string, unknown>,
        pOptions?: {
            RPT_CHART_WIDTH: number,
            RPT_CHART_HEIGHT: number
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    ResetStatisticsData({ pRequestParams }: {
        pRequestParams: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetReportIds(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    GetReportCommonData({ lReportId }: {
        lReportId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<BaseReportAttributes>,
    GetFilterSettings({ lReportType }: {
        lReportType: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ReportFilterAttributes>,
    ExecuteReportAsyncCancelWaitingForSlaves({ strRequestId }: {
        strRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    /**
     * @deprecated
     */
    CancelStatisticsRequest({ strRequestId }: {
        strRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CollectStatisticsAsync({ pRequestParams }: {
        pRequestParams: Partial<StatsAttributes>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    CollectStatisticsAsyncGetData({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<StatsAttributes>
}