import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { OpenAPIIterator } from '../../data/common'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ScanDiapasons;

type DiapasonAttributes = {
    KLDPNS_ID: number,
    KLDPNS_DN: string,
    KLDPNS_LF: number,
    KLDPNS_ScanEnabled: boolean,
    KLDPNS_ILS?: Partial<{
        KLDPNS_IL_ISSUBNET: boolean,
        KLDPNS_IL_MASKORLOW: number,
        KLDPNS_IL_SUBNETORHI: number
    }>[]
}

type ScanDiapasons = BaseOpenAPIClient & {
    GetDiapasons({ vecFieldsToReturn, lMaxLifeTime }: {
        vecFieldsToReturn?: string[],
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<OpenAPIIterator>,
    GetDiapason({ idDiapason, pFields }: {
        idDiapason?: number,
        pFields?: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DiapasonAttributes>,
    UpdateDiapason({ idDiapason, pInfo }: {
        idDiapason: number,
        pInfo: Partial<DiapasonAttributes>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    RemoveDiapason({ idDiapason }: {
        idDiapason: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AddDiapason({ pInfo }: {
        pInfo: Omit<DiapasonAttributes, 'KLDPNS_ID'>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>
}
