import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = SecurityPolicy3;

type GrpParams = {
    KLSPL_SEC_GRP_NAME?: string,
    KLSPL_SEC_GRP_DESC?: string
}

type SecurityPolicy3 = BaseOpenAPIClient & {
    AddSecurityGroup({ pGrpParams, lVsId }: {
        pGrpParams: GrpParams,
        lVsId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    AddUserIntoSecurityGroup({ lUserId, lGrpId }: {
        lUserId: number,
        lGrpId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CloseUserConnections({ lUserId }: {
        lUserId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteSecurityGroup({ lGrpId }: {
        lGrpId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteUserFromSecurityGroup({ lGrpId, lUserId }: {
        lGrpId: number,
        lUserId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    MoveUserIntoOtherSecurityGroup({ lUserId, lGrpIdFrom, lGrpIdTo }: {
        lUserId: number,
        lGrpIdFrom: number,
        lGrpIdTo: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UpdateSecurityGroup({ lGrpId, pGrpParams }: {
        lGrpId: number,
        pGrpParams: GrpParams
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
