import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = SecurityPolicy;

type User = {
    KLSPL_USER_ID?: number,
    KLSPL_USER_NAME: string,
    KLSPL_USER_PWD?: string,
    KLSPL_USER_PWD_ENCRYPTED: string,
    KLSPL_USER_FULL_NAME?: string,
    KLSPL_USER_DESCRIPTION?: string,
    KLSPL_USER_MAIL?: string,
    KLSPL_USER_PHONE?: string,
    KLSPL_USER_ENABLED?: boolean,
    KLSPL_USER_UIS?: boolean,
    KLSPL_USER_REQUEST_PASSWORD?: boolean
}

type SecurityPolicy = BaseOpenAPIClient & {
    GetUsers({ lUserId, lVsId }: {
        lUserId: number,
        lVsId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<User[]>,
    AddUser({ pUser }: {
        pUser: User
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    UpdateUser({ lUserId, pUser }: {
        lUserId: number,
        pUser: Partial<User>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UpdateTrustee({ llTrusteeId, pUserData }: {
        llTrusteeId: bigint,
        pUserData: Partial<User>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteUser({ lUserId }: {
        lUserId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetCurrentUserId(lUserId: number, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    GetCurrentUserId2(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{ wstrDisplayName: string }>,
    ChangeUserPassword({ lUserId, wstrOldPassword, wstrNewPassword }: {
        lUserId: number,
        wstrOldPassword: string,
        wstrNewPassword: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SavePerUserData({ pUserData }: {
        pUserData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    LoadPerUserData(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    SavePerUserData2({ lUserId, binUserId, nVServerId, pUserData }: {
        lUserId: number,
        binUserId: string,
        nVServerId: number,
        pUserData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    LoadPerUserData2({ lUserId, binUserId, nVServerId }: {
        lUserId: number,
        binUserId: string,
        nVServerId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>
}
