import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { SecondaryServerAttributes } from '../../additional/SecondaryServerAttributes'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ServerHierarchy;
type ServerHierarchy = BaseOpenAPIClient & {
    DelServer({ lServer }: {
        lServer: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    FindSlaveServers({ wstrFilter, pFieldsToReturn, pFieldsToOrder, pParams, lMaxLifeTime }: {
        wstrFilter?: string,
        pFieldsToReturn: Array<string>,
        pFieldsToOrder: Array<string>,
        pParams?: Record<string, unknown>, // reserved
        lMaxLifeTime?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    GetChildServers({ nGroupId }: {
        nGroupId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SecondaryServerAttributes[]>,
    GetServerInfo({ lServer, pFields }: {
        lServer: number,
        pFields: Array<string>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SecondaryServerAttributes>,
    RegisterServer({ wstrDisplName, nGroupId, pCertificate, wstrNetAddress, pAdditionalInfo }: {
        wstrDisplName: string,
        nGroupId: number,
        pCertificate: string,
        wstrNetAddress: string,
        pAdditionalInfo: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    UpdateServer({ lServer, pInfo }: {
        lServer: number,
        pInfo: Pick<SecondaryServerAttributes, 'KLSRVH_SRV_DN' | 'KLSRVH_SRV_GROUPID'>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
