import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ServerTransportSettings;
type ServerTransportSettings = BaseOpenAPIClient & {
    SetFeatureActive({ szwCertType, bFeatureActive }: {
        szwCertType: string,
        bFeatureActive: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    IsFeatureActive({ szwCertType }: {
        szwCertType: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    GetCurrentConnectionSettings({ szwCertType }: {
        szwCertType: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    SetCustomSrvCertificate({ szwCertType, pCertData }: {
        szwCertType: string,
        pCertData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetOrCreateDefaultCertificate({ szwCertType, pSettings }: {
        szwCertType: string,
        pSettings: Record<string, unknown>,
        CERT_CHANGE_TIMEOUT: number,
        TRSP_SETTINGS_CERT_DATA: Record<string, unknown>,
        TRSP_SETTINGS_FQDN: string,
        TRSP_SETTINGS_CERT: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
