import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = ServiceNwcCommandProvider;
type ServiceNwcCommandProvider = BaseOpenAPIClient & {
    GetCommandPayload({ wstrCommandId }: {
        wstrCommandId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    SetCommandError({ wstrCommandId, pError }: {
        wstrCommandId: string,
        pError: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetCommandResult({ wstrCommandId, pResult }: {
        wstrCommandId: string,
        pResult: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
