import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = Session;
type Session = BaseOpenAPIClient & {
    CreateToken(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    StartSession(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    EndSession(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    Ping(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CreateBlob({ KLCST_TARGET_PORT, KLCST_LOCATIONS, KLCST_USER_COMMAND, KLCST_TARGET_HOST_NAME, KLCST_RDS_TICKET, KLCST_RDS_PASSWORD }: {
        KLCST_TARGET_PORT: number,
        KLCST_LOCATIONS: Record<string, unknown>[],
        KLCST_USER_COMMAND: number,
        KLCST_TARGET_HOST_NAME: string,
        KLCST_RDS_TICKET: string,
        KLCST_RDS_PASSWORD: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>
}
