import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { SpamEventAttributes } from '../../additional/SpamEventAttributes'
import BaseOpenAPIClient = require('../base-open-api-client');

export = SpamEvents;
type SpamEvents = BaseOpenAPIClient & {
    GetSpamList(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SpamEventAttributes[]>,
    RemoveFromSpamList({ pArraySpamEventIds }: {
        pArraySpamEventIds: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RemoveFromExclusion({ pArraySpamEventIds }: {
        pArraySpamEventIds: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AddToExclusion({ pArraySpamEventIds }: {
        pArraySpamEventIds: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
