import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ServerCloudHostAttributes } from '../../additional/ServerCloudHostAttributes'
import { ServerCloudAttributes } from '../../additional/ServerCloudAttributes'
import BaseOpenAPIClient = require('../base-open-api-client');

export = SrvCloud;
type SrvCloud = BaseOpenAPIClient & {
    GetCloudsInfo({ pParams }: {
        pParams?: Record<string, unknown> // reserved
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ServerCloudAttributes>,
    GetCloudHostInfo({ pCloudHostBinId, pFields, pParams }: {
        pCloudHostBinId: string,
        pFields: (keyof ServerCloudHostAttributes)[],
        pParams?: unknown // reserved
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<ServerCloudHostAttributes>
}
