import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = SrvIpmNewsAndStatistics;

type IpmData = {
    LicenseId: string,
    ApplicationId: number,
    ApplicationVersion: string,
    Localization: string,
    LtsId: string,
    HardwareId: string
}

type SrvIpmNewsAndStatistics = BaseOpenAPIClient & {
    SendStatistics({ pwchContentId }: {
        pwchContentId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetTrackingData({ pwchContentId }: {
        pwchContentId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<IpmData[]>
}
