import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { VecFieldToOrder } from '../../data/common'
import { SrvViewFetchParams, SrvViewName, SrvViewParams, SrvViewRecords, SrvViewResult } from '../../srv-views'
import BaseOpenAPIClient = require('../base-open-api-client');

export = SrvView;
type SrvView = BaseOpenAPIClient & {
    ResetIterator({ wstrViewName, wstrFilter, vecFieldsToReturn, vecFieldsToOrder, pParams, lifetimeSec }: {
        wstrViewName: SrvViewName,
        wstrFilter?: string,
        vecFieldsToReturn?: Array<string>,
        vecFieldsToOrder?: VecFieldToOrder[],
        pParams?: SrvViewParams,
        lifetimeSec?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetRecordCount({ wstrIteratorId }: {
        wstrIteratorId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetRecordRange<T>({ wstrIteratorId, nStart, nEnd }: {
        wstrIteratorId: string,
        nStart: number,
        nEnd: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SrvViewResult<
        T extends unknown ? Record<string, any> : T
    >>,
    ReleaseIterator({ wstrIteratorId }: {
        wstrIteratorId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    Fetch<ViewName extends SrvViewName>(params: SrvViewFetchParams<ViewName>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<SrvViewResult<
        ViewName extends unknown ? Record<string, any> : SrvViewRecords[ViewName]
    >>
}
