import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = SsContents;
type SsContents = BaseOpenAPIClient & {
    SS_GetNames({ wstrID, wstrProduct, wstrVersion }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    Ss_Read({ wstrID, wstrProduct, wstrVersion, wstrSection, skipDeserialization }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string,
        skipDeserialization?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<any>,
    Ss_Add({ wstrID, wstrProduct, wstrVersion, wstrSection, pNewData }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string,
        pNewData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    Ss_Update({ wstrID, wstrProduct, wstrVersion, wstrSection, pNewData }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string,
        pNewData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    Ss_Replace({ wstrID, wstrProduct, wstrVersion, wstrSection, pNewData, skipSerialization }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string,
        pNewData: Record<string, unknown>,
        skipSerialization?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    Ss_Clear({ wstrID, wstrProduct, wstrVersion, wstrSection, pNewData }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string,
        pNewData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    Ss_Delete({ wstrID, wstrProduct, wstrVersion, wstrSection, pData }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string,
        pData: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    Ss_CreateSection({ wstrID, wstrProduct, wstrVersion, wstrSection }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    Ss_DeleteSection({ wstrID, wstrProduct, wstrVersion, wstrSection }: {
        wstrID: string,
        wstrProduct: string,
        wstrVersion: string,
        wstrSection: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    Ss_Apply({ wstrID }: {
        wstrID: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, unknown>>,
    Ss_Release({ wstrID }: {
        wstrID: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
