import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

type SubnetSettings = {
    nIpAddress: number,
    nMask: number,
    wstrSubnetName: string,
    wstrComment?: string
}

export = SubnetMasks;
type SubnetMasks = BaseOpenAPIClient & {
    CreateSubnet({ pSubnetSettings }: {
        pSubnetSettings: SubnetSettings
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    DeleteSubnet({ nIpAddress, nMask }: {
        nIpAddress: number,
        nMask: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ModifySubnet({ nIpAddress, nMask, pSubnetSettings }: {
        nIpAddress: number,
        nMask: number,
        pSubnetSettings?: Partial<Omit<SubnetSettings, 'nMask' | 'nIpAddress'>>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
