import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { TaskEventFilterAttributes } from '../../additional/TaskEventFilterAttributes'
import { TaskSettings, TaskData, TaskStats, TaskAttributes } from '../../data/task'
import BaseOpenAPIClient = require('../base-open-api-client')

export = Tasks;
type Tasks = BaseOpenAPIClient & {
    ResetTasksIterator({ nGroupId, bGroupIdSignificant, bIncludeSupergroups }: {
        nGroupId: number,
        bGroupIdSignificant?: boolean,
        bIncludeSupergroups?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    getNextTask({ strTaskIteratorId, deserialize }: {
        strTaskIteratorId: string,
        deserialize: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskSettings>,
    RunTask({ strTask }: {
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SuspendTask({ strTask }: {
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AddHostToTask({ strTask, strHostName }: {
        strTask: string,
        strHostName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
    ResumeTask({ strTask }: {
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CancelTask({ strTask }: {
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteTask({ strTask }: {
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetTaskData<T extends TaskData = TaskData>({ taskId, skipDeserialization, strSrvObjId }: {
        taskId: string,
        skipDeserialization?: boolean,
        strSrvObjId?: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<T>,
    AddTask({ taskData, skipSerialization }: {
        taskData: Partial<TaskData>,
        skipSerialization?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    UpdateTask({ taskId, taskData, skipSerialization, strSrvObjId }: {
        taskId: string,
        taskData: Partial<TaskData>,
        skipSerialization?: boolean,
        strSrvObjId?: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetTaskStartEvent ({ strTask }: {
        strTask: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskEventFilterAttributes>,
    SetTaskStartEvent ({ taskId, startEventData, skipSerialization }: {
        taskId: string,
        startEventData: TaskEventFilterAttributes,
        skipSerialization?: boolean,
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetTasks({ hostGroupId, tasksCount, searchData, bGroupIdSignificant, bIncludeSupergroups, deserialize }: {
        hostGroupId: string,
        tasksCount?: number,
        searchData?: Partial<TaskAttributes>,
        bGroupIdSignificant?: boolean,
        bIncludeSupergroups?: boolean,
        deserialize?: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<object[]>,
    ResetHostIteratorForTaskStatus({ strTask, pFields2Return, nHostStateMask, nLifetime }: {
        strTask: string,
        pFields2Return: string[],
        nHostStateMask: number,
        nLifetime: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetHostStatusRecordRange({ strHostIteratorId, nStart, nEnd }: {
        strHostIteratorId: string,
        nStart: number,
        nEnd: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    ReleaseHostStatusIterator(strHostIteratorId: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetHostStatusRecordsCount(strHostIteratorId: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetTaskHistory(data: Record<string, unknown>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetTaskStatus(taskId: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        result?: undefined
    } | {
        result: unknown
    }>,
    GetTasksStatuses(tasks: unknown, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        result: unknown[]
    }>,
    DrainTasksRecursive({ iterator, tasksCount, searchData, deserialize }: {
        iterator: string,
        tasksCount: number,
        searchData: Record<string, unknown>,
        deserialize: boolean
    }, connection: Connection, tasks?: unknown[], cacheConfig?: CacheConfig): ApiResponsePromise<unknown[]>,
    GetTaskStatistics(taskId: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TaskStats>,
    GetNextHostStatus(iterator: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    ReleaseTasksIterator(iterator: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ProtectPassword(strPassword: string, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    UpdateCredPasswords({ wstrUser, wstrPass, wstrOldPass, pActions }: {
        wstrUser: string,
        wstrPass: string,
        wstrOldPass?: string,
        pActions?: Record<string, unknown>[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    CancelUpdateCredPasswords({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ResolveTaskId({ strPrtsTaskId }: {
        strPrtsTaskId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
