import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = TotpGlobalSettings;

type TotpSettings = {
    TotpIssuer: string
}

type TotpGlobalSettings = BaseOpenAPIClient & {
    Get2FaRequiredForAll(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    Set2FaRequiredForAll({ bRequiredForAll }: {
        bRequiredForAll: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetTotpGlobalSettings(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TotpSettings>,
    SetTotpGlobalSettings({ pSettings }: {
        pSettings: TotpSettings
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    IfCanConfigure2FaSettings(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>
}
