import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = TotpRegistration;
type TotpRegistration = BaseOpenAPIClient & {
    GenerateSecret(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{ PxgRetVal: unknown, pSecret: { TotpSecret?: unknown, TotpSecretQR?: { value: unknown } } }>,
    DeleteSecret({ wstrSecretId }: {
        wstrSecretId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SaveSecretForCurrentUser({ wstrSecretId, wstrValidationCode }: {
        wstrSecretId: string,
        wstrValidationCode: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ClearSecretForCurrentUser(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    IfCurrentUserMayClearSecret(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>
}
