import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { TrafficRestrictions } from '../../additional/TrafficRestrictions'
import BaseOpenAPIClient = require('../base-open-api-client');

export = TrafficManager;
type TrafficManager = BaseOpenAPIClient & {
    AddRestriction({ pRestriction }: {
        pRestriction: TrafficRestrictions
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    DeleteRestriction({ nRestrictionId }: {
        nRestrictionId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetRestrictions(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<TrafficRestrictions[]>,
    UpdateRestriction({ pRestriction, nRestrictionId }: {
        pRestriction: TrafficRestrictions,
        nRestrictionId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>
}
