import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = UaControl;

type DistributionPointScope = {
    ScopeId: number,
    ScopeName: string
}

type UaScopeParams = {
    ScopeGroups: DistributionPointScope[],
    ScopeNlaNetworks: DistributionPointScope[],
    ScopeBcDomains: DistributionPointScope[]
}

type DistributionPointSettings = {
    UaHostId: string,
    UaScope: UaScopeParams,
    UaPort: number,
    UaNonSslPort: number,
    UaMulticastAddr: string,
    UaCustomFolder: string,
    UaUpdTask: string,
    UaUpdFolder: string,
    UaDistributeUpdates: boolean,
    UaDistributePackages: boolean,
    UaIsCg: boolean,
    CgServerInitiateConnection: boolean,
    CgRemoteAddress: string,
    CgOpenMobilePort: boolean,
    CgMobilePort: number,
    CgMobileUrl: string,
    CgOpenMobileAuthPort: boolean,
    CgMobileAuthPort: number,
    CgOpenWebConsolePort: boolean,
    CgWebConsolePort: number,
    UaRunPushServer: boolean,
    UaPushServerPort: number
}

type UaControl = BaseOpenAPIClient & {
    GetUpdateAgentsDisplayInfoForHost({ wstrHostId }: {
        wstrHostId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        UaHostDisplayName: string,
        UaHostId: string,
        UaIsCg: boolean
    }[]>,
    GetAssignUasAutomatically(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    GetDefaultUpdateAgentRegistrationInfo(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DistributionPointSettings>,
    GetUpdateAgentsList(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DistributionPointSettings[]>,
    ModifyUpdateAgent({ pUaInfo }: {
        pUaInfo: Partial<DistributionPointSettings>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetUpdateAgentInfo({ wstrUaHostId }: {
        wstrUaHostId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DistributionPointSettings>,
    RegisterDmzGateway({ pCgInfo }: {
        pCgInfo: {
            'DmzCgAddress': string,
            'UaScope': UaScopeParams
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RegisterUpdateAgent({ pUaInfo }: {
        pUaInfo: Partial<DistributionPointSettings>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetAssignUasAutomatically({ bEnabled }: {
        bEnabled: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UnregisterUpdateAgent({ wstrUaHostId }: {
        wstrUaHostId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
