import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = UpdComps;

type UniversalUpdateTask = {
    arrCategoryFilter: string[],
    bDoUpdate: boolean
}

type UpdComps = BaseOpenAPIClient & {
    UpdateAsync({ pParams, wsRequestId }: {
        pParams: UniversalUpdateTask,
        wsRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    Stop({ wsRequestId, bWait }: {
        wsRequestId: string,
        bWait: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    AsyncUpdate({ pParams }: {
        pParams: UniversalUpdateTask
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>
}
