import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { RetranslatedUpdateComponentBundle } from '../../additional/RetranslatedUpdateComponentBundle'
import BaseOpenAPIClient = require('../base-open-api-client');

export = Updates;
type Updates = BaseOpenAPIClient & {
    GetUpdatesInfo({ pFilter }: {
        pFilter: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<RetranslatedUpdateComponentBundle[]>,
    GetAvailableUpdatesInfo({ strLocalization, pAvailableUpdateComps, pAvailableUpdateApps }: {
        strLocalization: string,
        pAvailableUpdateComps: Record<string, unknown>,
        pAvailableUpdateApps: Record<string, unknown>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown[]>
}
