import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { ParamDateTime } from '../../data/common'
import { DeviceEnrollmentRecipient, KscNotification } from '../../data/user';
import BaseOpenAPIClient = require('../base-open-api-client');

export = UserDevices;

type ProtocolSpecificData = {
    KLMDM_PROTINF_PROT_ID: number,
    KLMDM_PROTINF_HOST_ID: string,
    KLMDM_PROTINF_MTNC_SRV_ID: string,
    KLMDM_PROTINF_SIGN_PROF: boolean,
    KLMDM_PROTINF_FORCE_GEN_APPSTORE_LINK: boolean,
    KLMDM_PROTINF_PKG_ID: number
}

type DeviceCommand = {
    KLMDM_CMD_GUID: string,
    KLMDM_CMD_TYPE: string,
    KLMDM_CMD_ARG?: any,
    KLMDM_CMD_PROCESSFLAGS: number,
    KLMDM_CMD_STATUS: number,
    KLMDM_CMD_RESULT_INFO: string,
    KLMDM_CMD_RESULT_DATA: any
}

type DeviceCommandLibrary = {
    KLMDM_CMD_FLAG: number,
    KLMDM_CMD_TYPE: string,
    KLMDM_CMD_DEF_DISPLAY_NAME: string
}

type DeviceEnrollmentPackage = {
    KLMDM_ENR_PKG_ID: number,
    KLMDM_ENR_PKG_MDM_PROTOCOLS: number,
    KLMDM_ENR_PKG_CONTENT_TYPE: number,
    KLMDM_ENR_PKG_STATE: number,
    KLMDM_ENR_PKG_UNIFIED_URL: string,
    KLMDM_ENR_PKG_LIVE_TIME: ParamDateTime,
    KLMDM_ENR_PKG_REMAINING_TIME: ParamDateTime,
    KLMDM_ENR_PKG_PWD: string
}

type DeviceEnrollmentPackageFile = {
    KLMDM_ENR_PKG_FILE_INFO: any,
    KLMDM_ENR_PKG_FILE_TYPE_LIST: any[],
    KLMDM_ENR_PKG_FILE_STATUS: number
}

type JournalRecord = {
    KLMDM_JRNL_RECORD_TYPE: number,
    KLMDM_JRNL_RECORD: string,
    KLMDM_JRNL_DETAILS: string,
    KLMDM_JRNL_TIME_STAMP: string,
    KLMDM_JRNL_CMD_TYPE: string,
    KLMDM_JRNL_CMD_RESULT: string
}

type MultitenancyServerInfo = {
    MTNC_SRV_INFO_STR_ID: string,
    MTNC_SRV_INFO_PROT_ID: number,
    MTNC_SRV_INFO_HOST_DN: string,
    MTNC_SRV_INFO_PROD_DN: string,
    MTNC_SRV_INFO_PROD_DV: string
}

type UserDevices = BaseOpenAPIClient & {
    CreateEnrollmentPackage({ pUserId, lMdmProtocols, lDeliveryType, lLiveTime, c_wstrUrlFormat }: {
        pUserId: string,
        lMdmProtocols: number,
        lDeliveryType: number,
        lLiveTime: number,
        c_wstrUrlFormat: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<bigint>,
    CreateEnrollmentPackage2({ pUserId, lMdmProtocols, lContentType, lLiveTime, c_wstrUrlFormat, pRecipient, pNotification, pProtSpecInfo }: {
        pUserId: string,
        lMdmProtocols: number,
        lContentType: number,
        lLiveTime: number,
        c_wstrUrlFormat: string,
        pRecipient?: Partial<DeviceEnrollmentRecipient>,
        pNotification?: Partial<KscNotification>,
        pProtSpecInfo?: ProtocolSpecificData[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<bigint>,
    DeleteCommand({ c_wstrCommandGuid, bForced }: {
        c_wstrCommandGuid: string,
        bForced: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    DeleteDevice({ lDeviceId }: {
        lDeviceId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteEnrollmentPackage({ lEnrPkgId }: {
        lEnrPkgId: bigint
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GenerateQRCode({ strInputData, lQRCodeSize, lImageFormat }: {
        strInputData: string,
        lQRCodeSize: number,
        lImageFormat: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetCommands({ lDeviceId }: {
        lDeviceId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DeviceCommand[]>,
    GetCommandsLibrary(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DeviceCommandLibrary[]>,
    GetDecipheredCommandList({ llCommandFlags, pCommandsLibrary }: {
        llCommandFlags: bigint,
        pCommandsLibrary: Partial<DeviceCommandLibrary>[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DeviceCommandLibrary[]>,
    GetDevicesExtraData({ pDeviceIds, pCategories }: {
        pDeviceIds: number[],
        pCategories: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<any[]>,
    GetEnrollmentPackage({ llEnrPkgId }: {
        llEnrPkgId: bigint
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DeviceEnrollmentPackage>,
    GetEnrollmentPackageFileData({ c_wstrPackageId, c_wstrPackageFileType, lBuffOffset, lBuffSize }: {
        c_wstrPackageId: string,
        c_wstrPackageFileType: string,
        lBuffOffset: number,
        lBuffSize: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetEnrollmentPackageFileInfo({ c_wstrPackageId, c_wstrUserAgent, c_wstrPackageFileType }: {
        c_wstrPackageId: string,
        c_wstrUserAgent: string,
        c_wstrPackageFileType: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DeviceEnrollmentPackageFile>,
    GetEnrollmentPackages({ pUserId }: {
        pUserId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<DeviceEnrollmentPackage[]>,
    GetHostsUmdmInfo({ pHosts }: {
        pHosts: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<any[]>,
    GetJournalCommandResult({ llJrnlId }: {
        llJrnlId: bigint
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    GetJournalRecords({ lDeviceId }: {
        lDeviceId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<JournalRecord[]>,
    GetJournalRecords2({ lDeviceId }: {
        lDeviceId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<JournalRecord[]>,
    GetMobileAgentSettingStorageData({ lDeviceId, c_wstrSectionName }: {
        lDeviceId: number,
        c_wstrSectionName: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    GetMultitenancyServerSettings({ c_wstrMtncServerId }: {
        c_wstrMtncServerId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    GetMultitenancyServersInfo({ nProtocolIds }: {
        nProtocolIds: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<MultitenancyServerInfo[]>,
    GetNotAcceptedEulaIds(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number[]>,
    GetSyncInfo({ nGroupId, nGSyncId, pFields }: {
        nGroupId: number,
        nGSyncId: bigint,
        pFields: string[]
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<Record<string, any>>,
    IsEulaAccepted({ binEulaUID }: {
        binEulaUID: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    PostCommand({ lDeviceId, c_wstrCommandGuid, c_wstrCommandType, pArguments, lMdmProtocols, lProcessFlags }: {
        lDeviceId: number,
        c_wstrCommandGuid: string,
        c_wstrCommandType: string,
        pArguments: string[],
        lMdmProtocols?: number,
        lProcessFlags?: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    RecallCommand({ c_wstrCommandGuid }: {
        c_wstrCommandGuid: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<boolean>,
    SaveEulaAndAccept({ wstrProdName, wstrProdVersion, wstrProdDispName, wstrProdDispVersion, binEulaUID, wstrText, tTimeStamp, bAccept }: {
        wstrProdName: string,
        wstrProdVersion: string,
        wstrProdDispName: string,
        wstrProdDispVersion: string,
        binEulaUID: string,
        wstrText: string,
        tTimeStamp: string,
        bAccept: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    SetMultitenancyServerSettings({ c_wstrMtncServerId, pSettings }: {
        c_wstrMtncServerId: string,
        pSettings: Partial<MultitenancyServerInfo>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
