import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import { PermissionsStructure } from '../../additional/PermissionsStructure'
import { VirtualServerAttributes } from '../../additional/VirtualServerAttributes'
import BaseOpenAPIClient = require('../base-open-api-client');

type VServers = BaseOpenAPIClient & {
    AddVServerInfo(
        { strDisplayName, lParentGroup }: Pick<VServerType, 'strDisplayName' | 'lParentGroup'>,
        connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<VirtualServerAttributes>,
    DelVServer({ lVServer }: VServerId, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetPermissions({ lVServer }: VServerId, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<PermissionsStructure>,
    GetVServers({ lParentGroup }: Pick<VServerType, 'lParentGroup'>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<VirtualServerAttributes[]>,
    GetVServerInfo(
        { lVServer, pFields2Return }: Pick<VServerType, 'lVServer' | 'pFields2Return'>,
        connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<VirtualServerAttributes>,
    MoveVServer(params: { lNewParentGroup: number } & VServerId, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    RecallCertAndCloseConnections({ lVServer }: VServerId, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<unknown>,
    SetPermissions(
        { lVServer, pPermissions, bProtection }: Pick<VServerType, 'lVServer' | 'pPermissions' | 'bProtection'>,
        connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    UpdateVServerInfo({ lVServer, pInfo }: Pick<VServerType, 'lVServer' | 'pInfo'>, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}

type VServerType = {
    strDisplayName: string,
    lParentGroup: number,
    lVServer: number,
    pInfo: Pick<
        VirtualServerAttributes,
        'KLVSRV_DN' | 'KLVSRV_ENABLED' | 'KLVSRV_LIC_ENABLED' | 'KLVSRV_CREATED' | 'KLVSRV_CUSTOM_INFO' | 'KLVSRV_VS_DESCR' | 'KLVSRV_NF_CUSTOM_URL'
        >,
    pFields2Return: (keyof VirtualServerAttributes)[],
    pPermissions: PermissionsStructure,
    bProtection: boolean
}

type VServerId = Pick<VServerType, 'lVServer'>;
export = VServers;
