import { ApiResponsePromise, CacheConfig, Connection } from '../../types'
import BaseOpenAPIClient = require('../base-open-api-client');

export = VapmControlApi;

type EulaParams = BaseOpenAPIClient & {
    strEULAUrl?: string,
    strEULA?: string,
    /**
     * 0: Undefined, any of the following.
     * 1: Microsoft Windows update server
     * 2: Third-party software vendors (supported in updatable VLNS[3] bases).
     * 4: Kaspersky software updates.
     */
    nSource: number,
    nLCID: number
}

type EulaUpdateId = {
    nSource: number,
    nPatchDbId: number
}

type VapmControlApi = {
    AcceptEulas({ pEulaIDs }: {
        pEulaIDs: Array<number>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeclineEulas({ pEulaIDs }: {
        pEulaIDs: Array<number>
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CancelDeleteFilesForUpdates({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    CancelDownloadPatch({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ChangeApproval({ pUpdates, nApprovementState }: {
        pUpdates: EulaUpdateId[],
        nApprovementState: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    ChangeVulnerabilityIgnorance({ wstrVulnerabilityUid, wstrHostId, bIgnore }: {
        wstrVulnerabilityUid: string,
        wstrHostId: string,
        bIgnore: boolean
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DeleteFilesForUpdates({ pUpdatesIds, wstrRequestId }: {
        pUpdatesIds: ({
            nPatchDbId: number
        } | {
            nRevisionID: number
        })[],
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    DownloadPatchAsync({ llPatchGlbId, nLcid, wstrRequestId }: {
        llPatchGlbId: bigint,
        nLcid: number,
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>,
    GetAttributesSetVersionNum(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number>,
    GetDownloadPatchDataChunk({ wstrRequestId, nStartPos, nSizeMax }: {
        wstrRequestId: string,
        nStartPos: number,
        nSizeMax: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string>,
    GetDownloadPatchResult({ wstrRequestId }: {
        wstrRequestId: string
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<{
        wstrFileName: string,
        nSize: number
    }>,
    GetEulaParams(params: {
        nEulaId: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<EulaParams>,
    GetEulasIdsForPatchPrerequisites({ llPatchGlobalId, nLCID }: {
        llPatchGlobalId: bigint,
        nLCID: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number[]>,
    GetEulasIdsForUpdates({ pUpdates, nLcid }: {
        pUpdates: EulaUpdateId[],
        nLcid: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number[]>,
    GetEulasIdsForVulnerabilitiesPatches({ pVulnerabilities, nLcid }: {
        pVulnerabilities: Array<number>,
        nLcid: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number[]>,
    GetEulasInfo({ pUpdates, nLcid }: {
        pUpdates: EulaUpdateId[],
        nLcid: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<EulaParams[]>,
    GetPendingRulesTasks(noParams: null, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number[]>,
    GetSupportedLcidsForPatchPrerequisites({ llPatchGlobalId, nOriginalLcid }: {
        llPatchGlobalId: bigint,
        nOriginalLcid: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<number[]>,
    GetUpdateSupportedLanguagesFilter({ nUpdateSource }: {
        nUpdateSource: number
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<string[]>,
    SetPackagesToFixVulnerability({ wstrVulnerabilityUid, pPackages, pParams }: {
        wstrVulnerabilityUid: string,
        pPackages: number[],
        pParams: {
            nVulnPatchPkgLCID?: number
        }
    }, connection: Connection, cacheConfig?: CacheConfig): ApiResponsePromise<void>
}
