import BaseOpenAPIClient = require('./base-open-api-client');

declare const openApiClient: OpenAPIClient
export = openApiClient;
/**
 * Взаимодействие с Open API сервером.
 * Поставляет классы для работы с OAPI.
 * Поставляется интерфейс, позволяющий передать на клиент список реализованных классов методов.
 */
type OpenAPIClient = BaseOpenAPIClient & {
    interface: Record<string, Record<string, Function>>,
    utils: {
        SecondFactorRegistration: typeof import('./utils/second-factor-registration')
    } & Record<string, any>
}
