import { Connection } from '../../types'

declare const _exports: SecondFactorRegistrationUtils
export = _exports;
declare class SecondFactorRegistrationUtils {
    createConnection({ openAPIHost, openAPIPort, openAPIVersion }: {
        openAPIHost: string,
        openAPIPort: string,
        openAPIVersion: string
    }): Promise<Connection>;

    getSecret(connectionOptions: unknown): Promise<unknown>;
    register(connectionOptions: unknown, { secretId, securityCode }: {
        secretId: string,
        securityCode: string
    }): Promise<unknown>;

    makeRequest({ openAPIHost, openAPIPort, openAPIVersion, kscSessionCode, connectionId }: {
        openAPIHost: string,
        openAPIPort: string,
        openAPIVersion: string,
        kscSessionCode: string,
        connectionId: string
    }, command: string, data: unknown): Promise<unknown>;
}
