import { scalar } from './data/common'
import PureOpenAPIClient = require('./open-api-client/open-api-client')

export type PxgError = {
    code: number,
    module: string,
    file: string,
    line: number,
    message: string
}

type PxgErrorContainer = {
    PxgError: PxgError
}

export type ApiResponse<T, Error = PxgErrorContainer> = {
    result: T extends scalar ? T | Error : T & Error
}

export type Connection = typeof BaseConnection

export type ApiResponsePromise<T, E = PxgErrorContainer> = Promise<ApiResponse<T, E>>;

type AsyncFunction = (...args: any) => Promise<any>
type ParamsResolver<A extends any[]> = A extends [infer A1, Connection, CacheConfig?] ?
    A1 extends (scalar | null | any[]) ? Partial<[A1]> : [A1, RequestOptions?, CacheConfig?]
    : A
type ReturnReplacer<T extends AsyncFunction, WrappedResult extends boolean> =
    T extends (...params: infer A) => ApiResponsePromise<infer R> ?
        (...params: ParamsResolver<A>) => WrappedResult extends true ? ApiResponsePromise<R> : Promise<R>
        : T;
type OpenApiMethodsWrapper<T, WrappedResult extends boolean> = {
    [K in keyof T]: T[K] extends AsyncFunction ? ReturnReplacer<T[K], WrappedResult> : T[K]
};

export type OpenAPIClientService = {
    [K in keyof OpenAPIDynamicFields]: OpenApiMethodsWrapper<OpenAPIDynamicFields[K], false>
}

export type OpenAPIClientForPlugins = typeof PureOpenAPIClient & {
    [K in keyof OpenAPIDynamicFields]: OpenApiMethodsWrapper<OpenAPIDynamicFields[K], true>
}

export type OpenAPIClient = typeof PureOpenAPIClient & OpenAPIDynamicFields

export type CacheConfig = {
    useCache?: boolean,
    ttl?: number,
    forceRefresh?: boolean
}

type RequestOptions = {}

import { ReportManager } from './open-api-client/methods/report-manager'

// generated fields
import AdHosts = require('./open-api-client/methods/ad-hosts')
import AdSecManager = require('./open-api-client/methods/ad-sec-manager')
import AdfsSso = require('./open-api-client/methods/adfs-sso')
import AdmServerSettings = require('./open-api-client/methods/adm-server-settings')
import AkPatches = require('./open-api-client/methods/ak-patches')
import AppCtrlApi = require('./open-api-client/methods/app-ctrl-api')
import AsyncActionStateChecker = require('./open-api-client/methods/async-action-state-checker')
import AsyncActionStateCheckerGateway = require('./open-api-client/methods/async-action-state-checker-gateway')
import Auth = require('./open-api-client/methods/auth')
import CertPoolCtrl = require('./open-api-client/methods/cert-pool-ctrl')
import CertUtils = require('./open-api-client/methods/cert-utils')
import CgwHelper = require('./open-api-client/methods/cgw-helper')
import ChunkAccessor = require('./open-api-client/methods/chunk-accessor')
import CloudAccess = require('./open-api-client/methods/cloud-access')
import ConEvents = require('./open-api-client/methods/con-events')
import DataProtectionApi = require('./open-api-client/methods/data-protection-api')
import DatabaseInfo = require('./open-api-client/methods/database-info')
import DpeKeyService = require('./open-api-client/methods/dpe-key-service')
import EventNotificationProperties = require('./open-api-client/methods/event-notification-properties')
import EventProcessingFactory = require('./open-api-client/methods/event-processing-factory')
import EventProcessing = require('./open-api-client/methods/event-processing')
import ExtAud = require('./open-api-client/methods/ext-aud')
import ExtServerTenant = require('./open-api-client/methods/ext-server-tenant')
import ExtTenant = require('./open-api-client/methods/ext-tenant')
import FileAcceptor = require('./open-api-client/methods/file-acceptor')
import FileCategorizer2 = require('./open-api-client/methods/file-categorizer-2')
import GatewayConnection = require('./open-api-client/methods/gateway-connection')
import Gcm = require('./open-api-client/methods/gcm')
import GroupSyncIterator = require('./open-api-client/methods/group-sync-iterator')
import GroupSync = require('./open-api-client/methods/group-sync')
import GroupTaskControlApi = require('./open-api-client/methods/group-task-control-api')
import GuiContext = require('./open-api-client/methods/gui-context')
import Helpers = require('./open-api-client/methods/helpers')
import HostGroup = require('./open-api-client/methods/host-group')
import HostMoveRules = require('./open-api-client/methods/host-move-rules')
import HostTagsRulling = require('./open-api-client/methods/host-tags-rulling')
import HostTasks = require('./open-api-client/methods/host-tasks')
import HostsTags = require('./open-api-client/methods/hosts-tags')
import HstAccessControl = require('./open-api-client/methods/hst-access-control')
import HwInvStorage = require('./open-api-client/methods/hw-inv-storage')
import IVapmSrvService = require('./open-api-client/methods/i-vapm-srv-service')
import IWebServerSettings = require('./open-api-client/methods/i-web-server-settings')
import InventoryApi = require('./open-api-client/methods/inventory-api')
import KeyService = require('./open-api-client/methods/key-service')
import KillChain = require('./open-api-client/methods/killchain')
import KleverControl = require('./open-api-client/methods/klever-control')
import KsnInternal = require('./open-api-client/methods/ksn-internal')
import LicenseInfoSync = require('./open-api-client/methods/license-info-sync')
import LicenseKeys = require('./open-api-client/methods/license-keys')
import LicensePolicy = require('./open-api-client/methods/license-policy')
import Limits = require('./open-api-client/methods/limits')
import ListTags = require('./open-api-client/methods/list-tags')
import MdmCertCtrlApi = require('./open-api-client/methods/mdm-cert-ctrl-api')
import MigrationData = require('./open-api-client/methods/migration-data')
import NagCgwHelper = require('./open-api-client/methods/nag-cgw-helper')
import NagGuiCalls = require('./open-api-client/methods/nag-gui-calls')
import NagHstCtl = require('./open-api-client/methods/nag-hst-ctl')
import NagNetworkListApi = require('./open-api-client/methods/nag-network-list-api')
import NagRdu = require('./open-api-client/methods/nag-rdu')
import NagRemoteScreen = require('./open-api-client/methods/nag-remote-screen')
import NlaDefinedNetworks = require('./open-api-client/methods/nla-defined-networks')
import OAuth2 = require('./open-api-client/methods/oauth2')
import PackagesApi = require('./open-api-client/methods/packages')
import PatchParameters = require('./open-api-client/methods/patch-parameters')
import PlcDevApi = require('./open-api-client/methods/plc-dev-api')
import PluginDataStorage = require('./open-api-client/methods/plugin-data-storage')
import PluginData = require('./open-api-client/methods/plugin-data')
import PolicyProfiles = require('./open-api-client/methods/policy-profiles')
import Policy = require('./open-api-client/methods/policy')
import ProductBackendIntegration = require('./open-api-client/methods/product-backend-integration')
import ProductUserTokenIssuer = require('./open-api-client/methods/product-user-token-issuer')
import QbtNetworkListApi = require('./open-api-client/methods/qbt-network-list-api')
import QueriesStorage = require('./open-api-client/methods/queries-storage')
import Relations = require('./open-api-client/methods/relations')
import Request = require('./open-api-client/methods/request')
import RetrFiles = require('./open-api-client/methods/retr-files')
import Roles = require('./open-api-client/methods/roles')
import ScanDiapasons = require('./open-api-client/methods/scan-diapasons')
import SecurityPolicy3 = require('./open-api-client/methods/security-policy-3')
import SecurityPolicy = require('./open-api-client/methods/security-policy')
import ServerHierarchy = require('./open-api-client/methods/server-hierarchy')
import ServerTransportSettings = require('./open-api-client/methods/server-transport-settings')
import ServiceNwcCommandProvider = require('./open-api-client/methods/service-nwc-command-provider')
import ServiceNwcDeployment = require('./open-api-client/methods/service-nwc-deployment')
import Session = require('./open-api-client/methods/session')
import SiemExport = require('./open-api-client/methods/siem-export')
import SpamEvents = require('./open-api-client/methods/spam-events')
import SrvCloudStat = require('./open-api-client/methods/srv-cloud-stat')
import SrvCloud = require('./open-api-client/methods/srv-cloud')
import SrvIpmNewsAndStatistics = require('./open-api-client/methods/srv-ipm-news-and-statistics')
import SrvRi = require('./open-api-client/methods/srv-ri')
import SrvView = require('./open-api-client/methods/srv-view')
import SsContents = require('./open-api-client/methods/ss-contents')
import SubnetMasks = require('./open-api-client/methods/subnet-masks')
import Tasks = require('./open-api-client/methods/tasks')
import TotpGlobalSettings = require('./open-api-client/methods/totp-global-settings')
import TotpRegistration = require('./open-api-client/methods/totp-registration')
import TotpUserSettings = require('./open-api-client/methods/totp-user-settings')
import TrafficManager = require('./open-api-client/methods/traffic-manager')
import UaControl = require('./open-api-client/methods/ua-control')
import UpdComps = require('./open-api-client/methods/upd-comps')
import Updates = require('./open-api-client/methods/updates')
import UserDevices = require('./open-api-client/methods/user-devices')
import VServers = require('./open-api-client/methods/v-servers')
import VServers2 = require('./open-api-client/methods/v-servers2')
import VapmControlApi = require('./open-api-client/methods/vapm-control-api')
import BaseConnection = require('./connection-pool/base-connection');

type OpenAPIDynamicFields = {
    AdHosts: AdHosts,
    AdSecManager: AdSecManager,
    AdfsSso: AdfsSso,
    AdmServerSettings: AdmServerSettings,
    AkPatches: AkPatches,
    AppCtrlApi: AppCtrlApi,
    AsyncActionStateChecker: AsyncActionStateChecker,
    AsyncActionStateCheckerGateway: AsyncActionStateCheckerGateway,
    Auth: Auth,
    CertPoolCtrl: CertPoolCtrl,
    CertUtils: CertUtils,
    CgwHelper: CgwHelper,
    ChunkAccessor: ChunkAccessor,
    CloudAccess: CloudAccess,
    ConEvents: ConEvents,
    DataProtectionApi: DataProtectionApi,
    DatabaseInfo: DatabaseInfo,
    DpeKeyService: DpeKeyService,
    EventNotificationProperties: EventNotificationProperties,
    EventProcessingFactory: EventProcessingFactory,
    EventProcessing: EventProcessing,
    ExtAud: ExtAud,
    ExtServerTenant: ExtServerTenant,
    ExtTenant: ExtTenant,
    FileAcceptor: FileAcceptor,
    FileCategorizer2: FileCategorizer2,
    GatewayConnection: GatewayConnection,
    Gcm: Gcm,
    GroupSyncIterator: GroupSyncIterator,
    GroupSync: GroupSync,
    GroupTaskControlApi: GroupTaskControlApi,
    GuiContext: GuiContext,
    Helpers: Helpers,
    HostGroup: HostGroup,
    HostMoveRules: HostMoveRules,
    HostTagsRulling: HostTagsRulling,
    HostTasks: HostTasks,
    HostsTags: HostsTags,
    HstAccessControl: HstAccessControl,
    HwInvStorage: HwInvStorage,
    IVapmSrvService: IVapmSrvService,
    IWebServerSettings: IWebServerSettings,
    InventoryApi: InventoryApi,
    KeyService: KeyService,
    KillChain: KillChain,
    KleverControl: KleverControl,
    KsnInternal: KsnInternal,
    LicenseInfoSync: LicenseInfoSync,
    LicenseKeys: LicenseKeys,
    LicensePolicy: LicensePolicy,
    Limits: Limits,
    ListTags: ListTags,
    MdmCertCtrlApi: MdmCertCtrlApi,
    MigrationData: MigrationData,
    NagCgwHelper: NagCgwHelper,
    NagGuiCalls: NagGuiCalls,
    NagHstCtl: NagHstCtl,
    NagNetworkListApi: NagNetworkListApi,
    NagRdu: NagRdu,
    NagRemoteScreen: NagRemoteScreen,
    NlaDefinedNetworks: NlaDefinedNetworks,
    OAuth2: OAuth2,
    PackagesApi: PackagesApi,
    PatchParameters: PatchParameters,
    PlcDevApi: PlcDevApi,
    PluginDataStorage: PluginDataStorage,
    PluginData: PluginData,
    PolicyProfiles: PolicyProfiles,
    Policy: Policy,
    ProductBackendIntegration: ProductBackendIntegration,
    ProductUserTokenIssuer: ProductUserTokenIssuer,
    QbtNetworkListApi: QbtNetworkListApi,
    QueriesStorage: QueriesStorage,
    Relations: Relations,
    ReportManager: ReportManager,
    Request: Request,
    RetrFiles: RetrFiles,
    Roles: Roles,
    ScanDiapasons: ScanDiapasons,
    SecurityPolicy3: SecurityPolicy3,
    SecurityPolicy: SecurityPolicy,
    ServerHierarchy: ServerHierarchy,
    ServerTransportSettings: ServerTransportSettings,
    ServiceNwcCommandProvider: ServiceNwcCommandProvider,
    ServiceNwcDeployment: ServiceNwcDeployment,
    Session: Session,
    SiemExport: SiemExport,
    SpamEvents: SpamEvents,
    SrvCloudStat: SrvCloudStat,
    SrvCloud: SrvCloud,
    SrvIpmNewsAndStatistics: SrvIpmNewsAndStatistics,
    SrvRi: SrvRi,
    SrvView: SrvView,
    SsContents: SsContents,
    SubnetMasks: SubnetMasks,
    Tasks: Tasks,
    TotpGlobalSettings: TotpGlobalSettings,
    TotpRegistration: TotpRegistration,
    TotpUserSettings: TotpUserSettings,
    TrafficManager: TrafficManager,
    UaControl: UaControl,
    UpdComps: UpdComps,
    Updates: Updates,
    UserDevices: UserDevices,
    VServers: VServers,
    VServers2: VServers2,
    VapmControlApi: VapmControlApi
}
