"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRegistrationHandler = void 0;
const services_1 = require("../../services");
const messageHandler_1 = require("./messageHandler");
const getRegistrationHandler = (responseFunctionName, createSubject, isAdditive) => async ({ actions, implementationOptions, productId, productVersion }) => {
    const subject = createSubject({
        implementationOptions,
        responseFunctionName,
        productId,
        productVersion,
    });
    const subscriber = new services_1.NatsSubscriber(subject, (0, messageHandler_1.getMessageHandler)(subject, actions, isAdditive));
    subscriber.subscribe();
};
exports.getRegistrationHandler = getRegistrationHandler;
