"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const getRegistrationHandler_1 = require("./getRegistrationHandler");
const responseTasks_1 = require("./responseTasks");
const jsonSchemaValidation_1 = require("./jsonSchemaValidation");
const createHash = implementationOptions => {
    return (0, crypto_1.createHash)('sha256').update(JSON.stringify(implementationOptions)).digest('hex');
};
const createSubject = ({ implementationOptions, productId, productVersion, responseFunctionName }) => {
    const hash = createHash(implementationOptions);
    return `${responseFunctionName}-${productId}-${productVersion}-${hash}`;
};
const registrationHandlerCreator = (responseFunctionName, isAdditive = false) => (0, getRegistrationHandler_1.getRegistrationHandler)(responseFunctionName, createSubject, isAdditive);
const getOpenApiToken = sctx => sctx.accessTokens.sid;
const responseApi = {
    createHash,
    registerMoveHosts: registrationHandlerCreator('moveHosts'),
    registerMoveHostsAdditive: registrationHandlerCreator('moveHostsAdditive', true),
    registerAvScan: registrationHandlerCreator('avScan'),
    registerAvScanAdditive: registrationHandlerCreator('avScanAdditive', true),
    registerChangeAuthorizationStatus: registrationHandlerCreator('changeAuthorizationStatus'),
    registerChangeAuthorizationStatusAdditive: registrationHandlerCreator('changeAuthorizationStatusAdditive', true),
    registerKillProcess: registrationHandlerCreator('killProcess'),
    registerKillProcessAdditive: registrationHandlerCreator('killProcessAdditive', true),
    registerQuarantineFile: registrationHandlerCreator('quarantineFile'),
    registerQuarantineFileAdditive: registrationHandlerCreator('quarantineFileAdditive', true),
    registerUpdateBases: registrationHandlerCreator('updateBases'),
    registerUpdateBasesAdditive: registrationHandlerCreator('updateBasesAdditive', true),
    registerExecuteCommandStatus: registrationHandlerCreator('executeCommand'),
    registerExecuteCommandStatusAdditive: registrationHandlerCreator('executeCommandAdditive', true),
    registerAssignKasapGroup: registrationHandlerCreator('assignKasapGroup'),
    registerAssignKasapGroupAdditive: registrationHandlerCreator('assignKasapGroupAdditive', true),
    getOpenApiToken,
    tasks: (0, responseTasks_1.getResponseTaskApi)(),
    validateImplementationOptions: jsonSchemaValidation_1.default,
};
__exportStar(require("./types"), exports);
exports.default = responseApi;
