"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateData = void 0;
const ajv_1 = require("ajv");
const schema = {
    type: 'object',
    minProperties: 1,
    patternProperties: {
        '^[a-zA-Z]+$': {
            type: 'object',
            minProperties: 1,
            properties: {
                multiAsset: {
                    type: 'boolean',
                    nullable: true,
                },
                additive: {
                    type: 'boolean',
                    nullable: true,
                },
                idempotent: {
                    type: 'boolean',
                    nullable: true,
                },
                installationRequired: {
                    type: 'boolean',
                    nullable: true,
                },
                assetIntegrations: {
                    type: 'array',
                    items: {
                        type: 'string',
                    },
                    nullable: true,
                },
            },
            additionalProperties: false,
        },
    },
    additionalProperties: false,
};
const ajv = new ajv_1.default();
const validate = ajv.compile(schema);
const validateData = (data) => validate(data);
exports.validateData = validateData;
const validateImplementationOptions = (data, callback) => {
    const isDataValid = (0, exports.validateData)(data);
    if (!isDataValid) {
        callback(new Error(`Implementation options validation: Invalid data. Check plugin's config.json`));
    }
    callback();
};
exports.default = validateImplementationOptions;
