"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getResponseFunctionAdditiveActionArgs = void 0;
const constants_1 = require("../../../constants");
const getResponseFunctionAdditiveActionArgs = ({ action, args }) => {
    var _a;
    const { ctx, sctx, cookie = '', forceForIncomplete = false, params = {}, asset, scope } = args;
    const dataForLogs = JSON.parse(JSON.stringify({
        action,
        args
    }));
    (_a = dataForLogs === null || dataForLogs === void 0 ? void 0 : dataForLogs.args) === null || _a === void 0 ? true : delete _a.sctx;
    runtime.logger.log(`Sended message from interpreter: ${JSON.stringify(dataForLogs)}`);
    if (!(ctx && sctx)) {
        return { errorMessage: constants_1.ERROR_MESSAGE_NO_CTX };
    }
    switch (action) {
        case 'check': {
            if (!asset) {
                return { errorMessage: constants_1.ERROR_MESSAGE_NO_ASSET };
            }
            const args = [ctx, sctx, cookie, asset];
            return args;
        }
        case 'cleanup': {
            if (!scope) {
                return { errorMessage: constants_1.ERROR_MESSAGE_NO_SCOPE };
            }
            const args = [
                ctx,
                sctx,
                cookie,
                scope,
                forceForIncomplete
            ];
            return args;
        }
        case 'create': {
            const args = [ctx, sctx, params];
            return args;
        }
        case 'run': {
            if (!asset) {
                return { errorMessage: constants_1.ERROR_MESSAGE_NO_ASSET };
            }
            const args = [ctx, sctx, cookie, asset];
            return args;
        }
        default:
            return { errorMessage: constants_1.ERROR_MESSAGE_NO_VALID_ACTION };
    }
};
exports.getResponseFunctionAdditiveActionArgs = getResponseFunctionAdditiveActionArgs;
