"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getResponseFunctionActionArgs = void 0;
const constants_1 = require("../../../constants");
const getResponseFunctionActionArgs = ({ action, args }) => {
    var _a;
    const { ctx, sctx, cookie = '', forceForIncomplete = false, interestedAssets, interestedCodes, params = {}, assets = [] } = args;
    const dataForLogs = JSON.parse(JSON.stringify({
        action,
        args
    }));
    (_a = dataForLogs === null || dataForLogs === void 0 ? void 0 : dataForLogs.args) === null || _a === void 0 ? true : delete _a.sctx;
    runtime.logger.log(`Sended message from interpreter: ${JSON.stringify(dataForLogs)}`);
    if (!(ctx && sctx)) {
        return { errorMessage: constants_1.ERROR_MESSAGE_NO_CTX };
    }
    switch (action) {
        case 'check': {
            const args = [ctx, sctx, cookie];
            return args;
        }
        case 'cleanup': {
            const args = [ctx, sctx, cookie, forceForIncomplete];
            return args;
        }
        case 'detail': {
            const args = [
                ctx,
                sctx,
                cookie,
                interestedAssets,
                interestedCodes
            ];
            return args;
        }
        case 'run': {
            const args = [ctx, sctx, params, assets];
            return args;
        }
        default:
            return { errorMessage: constants_1.ERROR_MESSAGE_NO_VALID_ACTION };
    }
};
exports.getResponseFunctionActionArgs = getResponseFunctionActionArgs;
