import { ResponseAvScan, ResponseAvScanAdditive, ResponseChangeAuthorizationStatus, ResponseChangeAuthorizationStatusAdditive, ResponseFunctionWithAdditiveScope, ResponseFunctionWithFixedScope, ResponseImplementationOptions, ResponseKillProcess, ResponseKillProcessAdditive, ResponseMoveHosts, ResponseMoveHostsAdditive, ResponseQuarantineFile, ResponseQuarantineFileAdditive, ResponseRestoreQuarantinedFile, ResponseRestoreQuarantinedFileAdditive, ResponseUpdateBases, ResponseUpdateBasesAdditive, ResponseExecuteCommandProcess, ResponseExecuteCommandAdditive, ResponseAssignKasapGroup, ResponseAssignKasapGroupAdditive, SecurityContext } from './responseFunctions';
export * from './responseTasks';
export * from './responseFunctions';
export * from './nats';
export * from './assetsIdentification';
import * as Undertaker from 'undertaker';
export { ResponseImplementationOptions };
export declare type ResponseFunction = ResponseFunctionWithAdditiveScope | ResponseFunctionWithFixedScope;
export declare type RegisterParams<T extends ResponseFunction> = {
    actions: T;
    implementationOptions: ResponseImplementationOptions;
    productId: string;
    productVersion: string;
};
import { ResponseTasks } from './responseTasks';
export declare type Plugin = {
    product: {
        id: string;
        version: string;
    };
    integration?: {
        responseFunctions?: {
            supported: boolean;
            types: Record<string, unknown>;
        };
    };
};
export declare type Config = {
    plugin: Plugin;
};
export declare type RegisterFunction<T extends ResponseFunction = ResponseFunction> = (registerParams: RegisterParams<T>) => Promise<void>;
export declare type RegisterMoveHosts = RegisterFunction<ResponseMoveHosts>;
export declare type RegisterAvScan = RegisterFunction<ResponseAvScan>;
export declare type RegisterKillProcess = RegisterFunction<ResponseKillProcess>;
export declare type RegisterUpdateBases = RegisterFunction<ResponseUpdateBases>;
export declare type RegisterQuarantineFile = RegisterFunction<ResponseQuarantineFile>;
export declare type RegisterRestoreQuarantinedFile = RegisterFunction<ResponseRestoreQuarantinedFile>;
export declare type RegisterChangeAuthorizationStatus = RegisterFunction<ResponseChangeAuthorizationStatus>;
export declare type RegisterExecuteCommandStatus = RegisterFunction<ResponseExecuteCommandProcess>;
export declare type RegisterAssignKasapGroup = RegisterFunction<ResponseAssignKasapGroup>;
export declare type RegisterMoveHostsAdditive = RegisterFunction<ResponseMoveHostsAdditive>;
export declare type RegisterAvScanAdditive = RegisterFunction<ResponseAvScanAdditive>;
export declare type RegisterKillProcessAdditive = RegisterFunction<ResponseKillProcessAdditive>;
export declare type RegisterUpdateBasesAdditive = RegisterFunction<ResponseUpdateBasesAdditive>;
export declare type RegisterQuarantineFileAdditive = RegisterFunction<ResponseQuarantineFileAdditive>;
export declare type RegisterRestoreQuarantinedFileAdditive = RegisterFunction<ResponseRestoreQuarantinedFileAdditive>;
export declare type RegisterChangeAuthorizationStatusAdditive = RegisterFunction<ResponseChangeAuthorizationStatusAdditive>;
export declare type RegisterExecuteCommandStatusAdditive = RegisterFunction<ResponseExecuteCommandAdditive>;
export declare type RegisterAssignKasapGroupAdditive = RegisterFunction<ResponseAssignKasapGroupAdditive>;
export declare type GetOpenApiToken = (sctx: SecurityContext) => string;
export declare type CreateHash = (implementationOptions: ResponseImplementationOptions) => string;
declare type ValidateImplementationOptions = (data: unknown, callback: Undertaker.TaskCallback) => void;
export declare type PlatformVersion = {
    registerMoveHosts: RegisterMoveHosts;
    registerAvScan: RegisterAvScan;
    registerKillProcess: RegisterKillProcess;
    registerUpdateBases: RegisterUpdateBases;
    registerQuarantineFile: RegisterQuarantineFile;
    registerRestoreQuarantinedFile?: RegisterRestoreQuarantinedFile;
    registerChangeAuthorizationStatus: RegisterChangeAuthorizationStatus;
    registerExecuteCommandStatus: RegisterExecuteCommandStatus;
    registerAssignKasapGroup: RegisterAssignKasapGroup;
    registerMoveHostsAdditive: RegisterMoveHostsAdditive;
    registerAvScanAdditive: RegisterAvScanAdditive;
    registerKillProcessAdditive: RegisterKillProcessAdditive;
    registerUpdateBasesAdditive: RegisterUpdateBasesAdditive;
    registerQuarantineFileAdditive: RegisterQuarantineFileAdditive;
    registerRestoreQuarantinedFileAdditive?: RegisterRestoreQuarantinedFileAdditive;
    registerChangeAuthorizationStatusAdditive: RegisterChangeAuthorizationStatusAdditive;
    registerExecuteCommandStatusAdditive: RegisterExecuteCommandStatusAdditive;
    registerAssignKasapGroupAdditive: RegisterAssignKasapGroupAdditive;
    createHash: CreateHash;
    getOpenApiToken: GetOpenApiToken;
    tasks: ResponseTasks;
    validateImplementationOptions: ValidateImplementationOptions;
};
