import { AssetLocator } from '../assetsIdentification';
export declare type ResponseContext = {
    responseId: string;
    tenantId: string;
    extra: {
        ksc: IdsKsc;
    };
};
export declare type IdsKsc = {
    instanceId: string;
    virtualServerId: string;
};
export declare type SecurityContext = {
    accessTokens: {
        [integrationId: string]: string;
        IAM: string;
    };
};
export declare type ResponseResultCodeSuccess = 'ok' | 'warning';
export declare type ResponseResultCodeFailed = 'retry' | 'fail';
export declare type ResponseResultCodeNeutral = 'pending' | 'canceled' | 'inapplicable';
export declare type ResponseResultCode = ResponseResultCodeSuccess | ResponseResultCodeFailed | ResponseResultCodeNeutral;
export declare type ResponseErrorCode = 'unsupported' | 'unavailable' | 'timeout' | 'noLicense' | 'badParams' | 'internalError';
export declare type ResponseResultSuccess = {
    resultCode: ResponseResultCodeSuccess;
};
export declare type ResponseResultNeutral = {
    resultCode: ResponseResultCodeNeutral;
};
export declare type ResponseResultFailed = {
    resultCode: ResponseResultCodeFailed;
    errorCode?: ResponseErrorCode;
    internalCode?: string;
};
export declare type ResponseResultDescription = (ResponseResultSuccess | ResponseResultFailed | ResponseResultNeutral) & {
    description?: string;
};
export declare type ResponseResultMultiAsset = ResponseResultDescription & {
    multiAssetResultCodesCounts?: {
        [resultCode in ResponseResultCode]?: number;
    };
};
export declare type ResponseResultMultiAssetEntry = ResponseResultDescription & {
    asset: AssetLocator;
};
export declare type ResponseRequestResult<T> = ResponseResultFailed | (ResponseResultSuccess & {
    result?: T;
});
export declare type ResponseImplementationOptions = {
    multiAsset?: boolean;
    additive?: boolean;
    idempotent?: boolean;
    installationRequired?: boolean;
    assetIntegrations?: string[];
};
export interface ResponseFunctionWithFixedScope<InParams = Record<string, unknown>, OutParams = Record<string, unknown>> {
    run(ctx: ResponseContext, sctx: SecurityContext, params: InParams, assets: AssetLocator[]): Promise<ResponseResultMultiAsset & {
        details?: OutParams;
    } & {
        cookie?: string;
        multiAssetDetails?: (ResponseResultMultiAssetEntry & {
            details?: OutParams;
        })[];
    }>;
    check(ctx: ResponseContext, sctx: SecurityContext, cookie: string): Promise<ResponseResultMultiAsset & {
        details?: OutParams;
    }>;
    detail(ctx: ResponseContext, sctx: SecurityContext, cookie: string, interestedAssets?: AssetLocator[], interestedCodes?: ResponseResultCode[]): Promise<ResponseRequestResult<(ResponseResultMultiAssetEntry & {
        details?: OutParams;
    })[]>>;
    cleanup(ctx: ResponseContext, sctx: SecurityContext, cookie: string, forceForIncomplete: boolean): Promise<ResponseRequestResult<Record<string, unknown>>>;
}
export interface ResponseFunctionWithAdditiveScope<InParams = Record<string, unknown>, OutParams = Record<string, unknown>> {
    create(ctx: ResponseContext, sctx: SecurityContext, params: InParams): Promise<ResponseResultDescription & {
        cookie?: string;
    }>;
    run(ctx: ResponseContext, sctx: SecurityContext, cookie: string, asset: AssetLocator): Promise<ResponseResultDescription & {
        details?: OutParams;
    }>;
    check(ctx: ResponseContext, sctx: SecurityContext, cookie: string, asset: AssetLocator): Promise<ResponseRequestResult<ResponseResultDescription & {
        details?: OutParams;
    }>>;
    cleanup(ctx: ResponseContext, sctx: SecurityContext, cookie: string, scope: AssetLocator | 'all', forceForIncomplete: boolean): Promise<ResponseRequestResult<Record<string, unknown>>>;
}
export declare type ResponseFunctionWithFixedScopeAction = keyof ResponseFunctionWithFixedScope;
export declare type ResponseFunctionWithAdditiveScopeAction = keyof ResponseFunctionWithAdditiveScope;
export declare type ResponseFunctionAction = ResponseFunctionWithAdditiveScopeAction | ResponseFunctionWithFixedScopeAction;
