import { AssetLocator } from './assetsIdentification';
import { ResponseContext, ResponseResultDescription, SecurityContext } from './responseFunctions';
export declare type ProductTaskType = {
    productId: string;
    productVersion: string;
    taskType: string;
};
export declare type ParamDateTime = {
    readonly type: 'datetime';
    value: string;
};
export declare type ProductTaskInfo = ProductTaskType & {
    taskUid: string;
    taskName: string;
};
export declare type ResponseTaskState = 1 | 2 | 4 | 8 | 16 | 32 | 64;
export declare type ResponseTaskEvent = Record<string, unknown>;
export declare type ResponseTaskStateInfo = {
    asset: AssetLocator;
    state: ResponseTaskState;
    progressPercent: number;
    descr?: string;
    startDateTimeISO?: string;
    finishDateTimeISO?: string;
    eventDbId?: string;
};
export declare type ListContainer = {
    HostName: string;
};
declare type ErrorContainer = {
    PxgError: {
        message: string;
        code: number;
    };
};
export declare type ResultContainer<S extends string, T> = {
    result: {
        [value in S]: T;
    } | ErrorContainer;
};
export declare type ResultContainerAddTask = ResultContainer<'PxgRetVal', string>;
export declare type ResultContainerHistoryTask = ResultContainer<'strIteratorId', string>;
export declare type ResultContainerRecordRange = ResultContainer<'KLEVP_EVENT_RANGE_ARRAY', Record<string, unknown>[]>;
export declare type ResultContainerGetHostStatusRecordsCount = ResultContainer<'PxgRetVal', number>;
export declare type transformParamsListContainers = (targetHosts: AssetLocator[]) => ListContainer[];
export interface ResponseTasks {
    calculateIdempotentTaskUid(ctx: ResponseContext, taskType: ProductTaskType): Promise<ResponseResultDescription & {
        taskUid: string;
    }>;
    runResponseTask(ctx: ResponseContext, sctx: SecurityContext, taskType: ProductTaskType, targetHosts: AssetLocator[], taskSettings: Record<string, unknown>): Promise<ResponseResultDescription & {
        taskUid: string;
        taskName: string;
    }>;
    addHostToTask(ctx: ResponseContext, sctx: SecurityContext, taskUid: string, targetHost: AssetLocator): Promise<ResponseResultDescription>;
    getTaskStatistics(ctx: ResponseContext, sctx: SecurityContext, taskUid: string): Promise<ResponseResultDescription & {
        statistics: {
            taskState: ResponseTaskState;
            count: number;
        }[];
    }>;
    getTaskStates(ctx: ResponseContext, sctx: SecurityContext, taskUid: string, targetHosts?: AssetLocator[], interestedStates?: ResponseTaskState[]): Promise<ResponseResultDescription & {
        states: ResponseTaskStateInfo[];
    }>;
    getTaskEvents(ctx: ResponseContext, sctx: SecurityContext, taskUid: string, targetHosts?: AssetLocator[], filter?: string): Promise<ResponseResultDescription & {
        events: ResponseTaskEvent[];
    }>;
    deleteTask(ctx: ResponseContext, sctx: SecurityContext, taskUid: string, forceForIncomplete: boolean): Promise<ResponseResultDescription>;
}
export declare type TaskType = {
    type: string;
    CID_ComponentID: string;
};
export declare type Statuses = {
    type: string;
    value: {
        completed_percent: number;
        hostdn: string;
        hostname: string;
        start_time?: {
            type: 'datetime';
            value: string;
        };
        finish_time?: {
            type: 'datetime';
            value: string;
        };
        state_code: ResponseTaskState;
        state_descr?: string;
        domain_name?: string;
        src_event_id?: {
            type: 'long';
            value: string;
        };
    };
};
export declare type StatusHostTasks = {
    statuses: Statuses[];
};
export declare type GetResponseTaskApi = () => ResponseTasks;
export {};
