"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NatsBucket = void 0;
const nats_1 = require("nats");
const connection_options_1 = require("./connection-options");
const constants_1 = require("./constants");
class NatsBucket {
    async connectOrCreate() {
        try {
            const connectionOptions = (0, connection_options_1.getNatsConnectionOptions)();
            const nc = await (0, nats_1.connect)(connectionOptions);
            const jsc = nc.jetstream();
            this.bucket = await jsc.views.kv(constants_1.TASK_ID_STORE);
        }
        catch (error) {
            runtime.logger.error(`Error method connectOrCreate key-value nats storage: ${JSON.stringify(error)}`);
        }
    }
    async setTaskId(taskUid, taskId) {
        try {
            await this.connectOrCreate();
            const sc = (0, nats_1.StringCodec)();
            await this.bucket.put(taskUid, sc.encode(taskId));
        }
        catch (error) {
            runtime.logger.error(`Error method setTaskId key-value nats storage: ${JSON.stringify(error)}`);
        }
    }
    async getTaskId(taskUid) {
        try {
            await this.connectOrCreate();
            const sc = (0, nats_1.StringCodec)();
            const data = await this.bucket.get(taskUid);
            if (data) {
                return sc.decode(data.value);
            }
        }
        catch (error) {
            runtime.logger.error(`Error method getTaskId key-value nats storage: ${JSON.stringify(error)}`);
        }
    }
    async deleteKeyValue(taskUid) {
        try {
            await this.connectOrCreate();
            await this.bucket.delete(taskUid);
        }
        catch (error) {
            runtime.logger.error(`Error method deleteKeyValue key-value nats storage: ${JSON.stringify(error)}`);
        }
    }
}
exports.NatsBucket = NatsBucket;
