"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNatsConnectionOptions = void 0;
const natsAddress = process.env.NATS_ADDRESS;
const natsTlsCaFile = process.env.NATS_TLS_CAFILE;
const natsTlsCertFile = process.env.NATS_TLS_CERTFILE;
const natsTlsKeyFile = process.env.NATS_TLS_KEYFILE;
const getNatsConnectionOptions = () => {
    const opts = {
        servers: natsAddress
    };
    const tls = {};
    if (natsTlsCaFile === null || natsTlsCaFile === void 0 ? void 0 : natsTlsCaFile.length) {
        tls.caFile = natsTlsCaFile;
    }
    if (natsTlsCertFile === null || natsTlsCertFile === void 0 ? void 0 : natsTlsCertFile.length) {
        tls.certFile = natsTlsCertFile;
    }
    if (natsTlsKeyFile === null || natsTlsKeyFile === void 0 ? void 0 : natsTlsKeyFile.length) {
        tls.keyFile = natsTlsKeyFile;
    }
    if (Object.keys(tls).length) {
        opts.tls = tls;
    }
    return opts;
};
exports.getNatsConnectionOptions = getNatsConnectionOptions;
