"use strict";
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NatsSubscriber = void 0;
const nats_1 = require("nats");
const connection_options_1 = require("./connection-options");
const constants_1 = require("./constants");
class NatsSubscriber {
    constructor(subject, handleMessage, connectionOptions = (0, connection_options_1.getNatsConnectionOptions)(), onUnsubscribe) {
        this.subject = subject;
        this.handleMessage = handleMessage;
        this.connectionOptions = connectionOptions;
        this.onUnsubscribe = onUnsubscribe;
        runtime.logger.log(`${constants_1.LOGS_PREFIX}create new`, { connectionOptions });
    }
    async subscribe() {
        runtime.logger.log(`${constants_1.LOGS_PREFIX}new subscription`);
        try {
            this.connection = await (0, nats_1.connect)(this.connectionOptions);
        }
        catch (error) {
            runtime.logger.error(`${constants_1.LOGS_PREFIX}NATS Connection Error: ${error}`);
            return;
        }
        try {
            this.subscription = this.connection.subscribe(this.subject);
        }
        catch (error) {
            runtime.logger.error(`${constants_1.LOGS_PREFIX}NATS Subscription Error: ${error}`);
            return;
        }
        await this.processMessages();
        runtime.logger.log(`${constants_1.LOGS_PREFIX}subscription closed`);
    }
    async processMessages() {
        var e_1, _a;
        try {
            for (var _b = __asyncValues(this.subscription), _c; _c = await _b.next(), !_c.done;) {
                const msg = _c.value;
                try {
                    await this.handleMessage(msg, this.connection);
                }
                catch (e) {
                    runtime.logger.log(`${constants_1.LOGS_PREFIX}subscription exception fails: ${JSON.stringify(e)}`);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) await _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    async unsubscribe() {
        var _a;
        runtime.logger.log(`${constants_1.LOGS_PREFIX}unsubscribe`);
        this.subscription.unsubscribe();
        await this.connection.close();
        runtime.logger.log(`${constants_1.LOGS_PREFIX}unsubscribed`);
        (_a = this.onUnsubscribe) === null || _a === void 0 ? void 0 : _a.call(this);
    }
}
exports.NatsSubscriber = NatsSubscriber;
