const DataStore = require('./src/data-store')

class ExtendedMap extends Map {
  pushToList (name, value) {
    const list = this.getList(name)

    list.push(value)
    this.set(name, list)
  }

  getList (name) {
    return this.get(name) || []
  }

  getHashMap (name) {
    return this.get(name) || {}
  }

  removeFromListByValue (name, value) {
    const list = this.getList(name)
    const index = list.indexOf(value)

    if (list.includes(value)) {
      list.splice(index, 1)
    }
  }

  setToHashMap (name, key, value) {
    const hashMap = this.getHashMap(name)

    hashMap[key] = value
    this.set(name, hashMap)
  }

  removeFromHashMap (name, key) {
    const hashMap = this.get(name)
    delete hashMap[key]
  }

  getFromHashMap (name, key) {
    return this.get(name)[key]
  }
}

module.exports = class InMemoryDataStore extends DataStore {
  constructor () {
    super(...arguments)
    this.store = new ExtendedMap()
  }

  async get (key) {
    const entry = this.store.get(this.keyPrefix + key)
    return entry
  }

  async set (key, value) {
    this.validateKey(key)
    if (!this.keys.includes(key)) this.keys.push(key)
    this.store.set(this.keyPrefix + key, value)
  }

  async pushToList (name, value) {
    this.validateKey(name)
    if (!this.keys.includes(name)) this.keys.push(name)
    return this.store.pushToList(this.keyPrefix + name, value)
  }

  async setToHashMap (name, key, value) {
    this.validateKey(name)
    if (!this.keys.includes(name)) this.keys.push(name)
    return this.store.setToHashMap(this.keyPrefix + name, key, value)
  }

  async getFromHashMap (name, key) {
    return this.store.getFromHashMap(this.keyPrefix + name, key)
  }

  async removeFromListByValue (name, value) {
    return this.store.removeFromListByValue(this.keyPrefix + name, value)
  }

  async removeFromHashMap (name, key) {
    return this.store.removeFromHashMap(this.keyPrefix + name, key)
  }

  async getList (name) {
    return this.store.getList(this.keyPrefix + name)
  }

  async getHashMap (name) {
    return this.store.getHashMap(this.keyPrefix + name)
  }
}
