/**
 * This module is created for possible extension of post value processing scenarios in the future
 */

function getCastingInstructions (type) {
  switch (type) {
    case 'date':
      return {
        operation: 'cast',
        to: 'date'
      }
  }
}

/**
 * Get value post processing instructions if it's aplicable for current value
 */
function getInstructionsIfApplicable (value) {
  let res = []
  if (value instanceof Date) {
    let instruction = getCastingInstructions('date')
    res.push(instruction)
  }
  return res
}

function cast (targetType, val) {
  let res = val
  switch (targetType) {
    case 'date':
      res = new Date(val)
      break
  }
  return res
}

/**
 * Process instructions written by this module
 */
function processInstructions (instructions, rawValue) {
  let res = instructions.reduce((value, instruction) => {
    switch (instruction.operation) {
      case 'cast':
        return cast(instruction.to, value)
    }
  }, rawValue)
  return res
}

/**
 * Encrypts temporary data
 * @param { string } data - data to encrypt
 */
function encrypt (data) {
  // Temporary simplified
  return Buffer.from(data).toString('base64')
}

/**
 * Decrypts encrypted data
 * @param { string } encryptedData - data to decrypt
 */
function decrypt (encryptedData) {
  // Temporary simplified
  return Buffer.from(encryptedData, 'base64').toString()
}

module.exports = {
  getInstructionsIfApplicable,
  processInstructions,
  encrypt,
  decrypt
}
