/**
 * Product context factory class.
 * Stores data store factory instances under unique product id key
 */
const DataStoreFactory = require('./data-store-factory')

module.exports = class ProductContextFactory {
  constructor () {
    this.productsMap = new Map()
  }

  /**
   * Create data store for specific product. It holds all the data for this product.
   * Note: It's not possible to create multiple instances of product context
   * @param {string} productId Product identificator. I.e. root, kes_windows etc.
   */
  createProductContext (productId) {
    if (this.productsMap.has(productId)) {
      throw new Error(`Data store for product "${productId}" already exists`)
    }
    const dataStoreFactory = new DataStoreFactory({ keyPrefix: productId })
    this.productsMap.set(productId, dataStoreFactory)
    return dataStoreFactory
  }
}
