import { ApiError } from "./types";
export declare enum ErrorCode {
    ApiError = "BAD API",
    BadAuthentication = "BAD_AUTHENTICATION",
    BadCreds = "BAD_CREDS",
    BadHeader = "BAD_HEADER",
    BadJson = "BAD_JSON",
    BadPayload = "BAD_PAYLOAD",
    BadSubject = "BAD_SUBJECT",
    Cancelled = "CANCELLED",
    ConnectionClosed = "CONNECTION_CLOSED",
    ConnectionDraining = "CONNECTION_DRAINING",
    ConnectionRefused = "CONNECTION_REFUSED",
    ConnectionTimeout = "CONNECTION_TIMEOUT",
    Disconnect = "DISCONNECT",
    InvalidOption = "INVALID_OPTION",
    InvalidPayload = "INVALID_PAYLOAD",
    MaxPayloadExceeded = "MAX_PAYLOAD_EXCEEDED",
    NoResponders = "503",
    NotFunction = "NOT_FUNC",
    RequestError = "REQUEST_ERROR",
    ServerOptionNotAvailable = "SERVER_OPT_NA",
    SubClosed = "SUB_CLOSED",
    SubDraining = "SUB_DRAINING",
    Timeout = "TIMEOUT",
    Tls = "TLS",
    Unknown = "UNKNOWN_ERROR",
    WssRequired = "WSS_REQUIRED",
    JetStreamInvalidAck = "JESTREAM_INVALID_ACK",
    JetStream404NoMessages = "404",
    JetStream408RequestTimeout = "408",
    JetStream409MaxAckPendingExceeded = "409",
    JetStreamNotEnabled = "503",
    AuthorizationViolation = "AUTHORIZATION_VIOLATION",
    AuthenticationExpired = "AUTHENTICATION_EXPIRED",
    ProtocolError = "NATS_PROTOCOL_ERR",
    PermissionsViolation = "PERMISSIONS_VIOLATION"
}
export declare class Messages {
    messages: Map<string, string>;
    constructor();
    static getMessage(s: string): string;
    getMessage(s: string): string;
}
export declare function isNatsError(err: NatsError | Error): err is NatsError;
export declare class NatsError extends Error {
    name: string;
    message: string;
    code: string;
    chainedError?: Error;
    api_error?: ApiError;
    /**
     * @param {String} message
     * @param {String} code
     * @param {Error} [chainedError]
     * @constructor
     *
     * @api private
     */
    constructor(message: string, code: string, chainedError?: Error);
    static errorForCode(code: string, chainedError?: Error): NatsError;
    isAuthError(): boolean;
    isPermissionError(): boolean;
    isProtocolError(): boolean;
    isJetStreamError(): boolean;
    jsError(): ApiError | null;
}
