export interface MsgHdrs extends Iterable<[string, string[]]> {
    hasError: boolean;
    status: string;
    code: number;
    description: string;
    get(k: string, match?: Match): string;
    set(k: string, v: string, match?: Match): void;
    append(k: string, v: string, match?: Match): void;
    has(k: string, match?: Match): boolean;
    keys(): string[];
    values(k: string, match?: Match): string[];
    delete(k: string, match?: Match): void;
}
export declare function canonicalMIMEHeaderKey(k: string): string;
export declare function headers(): MsgHdrs;
export declare enum Match {
    Exact = 0,
    CanonicalMIME = 1,
    IgnoreCase = 2
}
export declare class MsgHdrsImpl implements MsgHdrs {
    code: number;
    headers: Map<string, string[]>;
    description: string;
    constructor();
    [Symbol.iterator](): IterableIterator<[string, string[]]>;
    size(): number;
    equals(mh: MsgHdrsImpl): boolean;
    static decode(a: Uint8Array): MsgHdrsImpl;
    toString(): string;
    encode(): Uint8Array;
    static validHeaderValue(k: string): string;
    keys(): string[];
    findKeys(k: string, match?: Match): string[];
    get(k: string, match?: Match): string;
    has(k: string, match?: Match): boolean;
    set(k: string, v: string, match?: Match): void;
    append(k: string, v: string, match?: Match): void;
    values(k: string, match?: Match): string[];
    delete(k: string, match?: Match): void;
    get hasError(): boolean;
    get status(): string;
}
