import { JetStreamOptions, Msg, NatsConnection, RequestOptions } from "./types";
import { Codec } from "./codec";
import { NatsConnectionImpl } from "./nats";
export declare function defaultJsOptions(opts?: JetStreamOptions): JetStreamOptions;
export declare class BaseApiClient {
    nc: NatsConnectionImpl;
    opts: JetStreamOptions;
    prefix: string;
    timeout: number;
    jc: Codec<unknown>;
    constructor(nc: NatsConnection, opts?: JetStreamOptions);
    _parseOpts(): void;
    _request(subj: string, data?: unknown, opts?: RequestOptions): Promise<unknown>;
    findStream(subject: string): Promise<string>;
    parseJsResponse(m: Msg): unknown;
}
