import type { ConsumerOptsBuilder, Views } from "./types";
import { ConsumerAPI, ConsumerInfo, ConsumerOpts, JetStreamClient, JetStreamOptions, JetStreamPublishOptions, JetStreamPullSubscription, JetStreamSubscription, JsMsg, NatsConnection, PubAck, PullOptions } from "./types";
import { BaseApiClient } from "./jsbaseclient_api";
import { TypedSubscriptionOptions } from "./typedsub";
import { IngestionFilterFn, QueuedIterator } from "./queued_iterator";
export interface JetStreamSubscriptionInfoable {
    info: JetStreamSubscriptionInfo | null;
}
export declare class JetStreamClientImpl extends BaseApiClient implements JetStreamClient {
    api: ConsumerAPI;
    constructor(nc: NatsConnection, opts?: JetStreamOptions);
    get views(): Views;
    publish(subj: string, data?: Uint8Array, opts?: Partial<JetStreamPublishOptions>): Promise<PubAck>;
    pull(stream: string, durable: string): Promise<JsMsg>;
    fetch(stream: string, durable: string, opts?: Partial<PullOptions>): QueuedIterator<JsMsg>;
    pullSubscribe(subject: string, opts?: ConsumerOptsBuilder | Partial<ConsumerOpts>): Promise<JetStreamPullSubscription>;
    subscribe(subject: string, opts?: ConsumerOptsBuilder | Partial<ConsumerOpts>): Promise<JetStreamSubscription>;
    _processOptions(subject: string, opts?: ConsumerOptsBuilder | Partial<ConsumerOpts>): Promise<JetStreamSubscriptionInfo>;
    _buildTypedSubscriptionOpts(jsi: JetStreamSubscriptionInfo): TypedSubscriptionOptions<JsMsg>;
    _maybeCreateConsumer(jsi: JetStreamSubscriptionInfo): Promise<void>;
    static ingestionFn(ordered: boolean): IngestionFilterFn<JsMsg>;
}
interface JetStreamSubscriptionInfo extends ConsumerOpts {
    api: BaseApiClient;
    last: ConsumerInfo;
    attached: boolean;
    deliver: string;
    bind: boolean;
    "ordered_consumer_sequence": {
        "delivery_seq": number;
        "stream_seq": number;
    };
    "flow_control": {
        "heartbeat_count": number;
        "fc_count": number;
        "consumer_restarts": number;
    };
}
export {};
