import { ConsumerConfig, ConsumerOpts, ConsumerOptsBuilder, JsMsgCallback } from "./types";
export declare function consumerOpts(opts?: Partial<ConsumerConfig>): ConsumerOptsBuilder;
export declare class ConsumerOptsBuilderImpl implements ConsumerOptsBuilder {
    config: Partial<ConsumerConfig>;
    ordered: boolean;
    mack: boolean;
    stream: string;
    callbackFn?: JsMsgCallback;
    max?: number;
    qname?: string;
    isBind?: boolean;
    constructor(opts?: Partial<ConsumerConfig>);
    getOpts(): ConsumerOpts;
    description(description: string): void;
    deliverTo(subject: string): void;
    durable(name: string): void;
    startSequence(seq: number): void;
    startTime(time: Date): void;
    deliverAll(): void;
    deliverLastPerSubject(): void;
    deliverLast(): void;
    deliverNew(): void;
    startAtTimeDelta(millis: number): void;
    headersOnly(): void;
    ackNone(): void;
    ackAll(): void;
    ackExplicit(): void;
    ackWait(millis: number): void;
    maxDeliver(max: number): void;
    filterSubject(s: string): void;
    replayInstantly(): void;
    replayOriginal(): void;
    sample(n: number): void;
    limit(n: number): void;
    maxWaiting(max: number): void;
    maxAckPending(max: number): void;
    idleHeartbeat(millis: number): void;
    flowControl(): void;
    deliverGroup(name: string): void;
    manualAck(): void;
    maxMessages(max: number): void;
    callback(fn: JsMsgCallback): void;
    queue(n: string): void;
    orderedConsumer(): void;
    bind(stream: string, durable: string): void;
    inactiveEphemeralThreshold(millis: number): void;
    maxPullBatch(n: number): void;
    maxPullRequestExpires(millis: number): void;
}
export declare function isConsumerOptsBuilder(o: ConsumerOptsBuilder | Partial<ConsumerOpts>): o is ConsumerOptsBuilderImpl;
