import { ConsumerAPI, ConsumerConfig, ConsumerInfo, ConsumerUpdateConfig, JetStreamOptions, Lister, NatsConnection } from "./types";
import { BaseApiClient } from "./jsbaseclient_api";
export declare class ConsumerAPIImpl extends BaseApiClient implements ConsumerAPI {
    constructor(nc: NatsConnection, opts?: JetStreamOptions);
    add(stream: string, cfg: ConsumerConfig): Promise<ConsumerInfo>;
    update(stream: string, durable: string, cfg: ConsumerUpdateConfig): Promise<ConsumerInfo>;
    info(stream: string, name: string): Promise<ConsumerInfo>;
    delete(stream: string, name: string): Promise<boolean>;
    list(stream: string): Lister<ConsumerInfo>;
}
