import { DeliveryInfo, JsMsg, Msg, NextRequest } from "./types";
import { MsgHdrs } from "./headers";
export declare const ACK: Uint8Array;
export declare function toJsMsg(m: Msg): JsMsg;
export declare function parseInfo(s: string): DeliveryInfo;
export declare class JsMsgImpl implements JsMsg {
    msg: Msg;
    di?: DeliveryInfo;
    didAck: boolean;
    constructor(msg: Msg);
    get subject(): string;
    get sid(): number;
    get data(): Uint8Array;
    get headers(): MsgHdrs;
    get info(): DeliveryInfo;
    get redelivered(): boolean;
    get reply(): string;
    get seq(): number;
    doAck(payload: Uint8Array): void;
    isWIP(p: Uint8Array): boolean;
    ackAck(): Promise<boolean>;
    ack(): void;
    nak(millis?: number): void;
    working(): void;
    next(subj?: string, ro?: Partial<NextRequest>): void;
    term(): void;
}
