"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsMsgImpl = exports.parseInfo = exports.toJsMsg = exports.ACK = void 0;
const databuffer_1 = require("./databuffer");
const codec_1 = require("./codec");
const request_1 = require("./request");
const jsutil_1 = require("./jsutil");
exports.ACK = Uint8Array.of(43, 65, 67, 75);
const NAK = Uint8Array.of(45, 78, 65, 75);
const WPI = Uint8Array.of(43, 87, 80, 73);
const NXT = Uint8Array.of(43, 78, 88, 84);
const TERM = Uint8Array.of(43, 84, 69, 82, 77);
const SPACE = Uint8Array.of(32);
function toJsMsg(m) {
    return new JsMsgImpl(m);
}
exports.toJsMsg = toJsMsg;
function parseInfo(s) {
    const tokens = s.split(".");
    if (tokens.length === 9) {
        tokens.splice(2, 0, "_", "");
    }
    if ((tokens.length < 11) || tokens[0] !== "$JS" || tokens[1] !== "ACK") {
        throw new Error(`not js message`);
    }
    // old
    // "$JS.ACK.<stream>.<consumer>.<redeliveryCount><streamSeq><deliverySequence>.<timestamp>.<pending>"
    // new
    // $JS.ACK.<domain>.<accounthash>.<stream>.<consumer>.<redeliveryCount>.<streamSeq>.<deliverySequence>.<timestamp>.<pending>.<random>
    const di = {};
    // if domain is "_", replace with blank
    di.domain = tokens[2] === "_" ? "" : tokens[2];
    di.account_hash = tokens[3];
    di.stream = tokens[4];
    di.consumer = tokens[5];
    di.redeliveryCount = parseInt(tokens[6], 10);
    di.redelivered = di.redeliveryCount > 1;
    di.streamSequence = parseInt(tokens[7], 10);
    di.deliverySequence = parseInt(tokens[8], 10);
    di.timestampNanos = parseInt(tokens[9], 10);
    di.pending = parseInt(tokens[10], 10);
    return di;
}
exports.parseInfo = parseInfo;
class JsMsgImpl {
    constructor(msg) {
        this.msg = msg;
        this.didAck = false;
    }
    get subject() {
        return this.msg.subject;
    }
    get sid() {
        return this.msg.sid;
    }
    get data() {
        return this.msg.data;
    }
    get headers() {
        return this.msg.headers;
    }
    get info() {
        if (!this.di) {
            this.di = parseInfo(this.reply);
        }
        return this.di;
    }
    get redelivered() {
        return this.info.redeliveryCount > 1;
    }
    get reply() {
        return this.msg.reply || "";
    }
    get seq() {
        return this.info.streamSequence;
    }
    doAck(payload) {
        if (!this.didAck) {
            // all acks are final with the exception of +WPI
            this.didAck = !this.isWIP(payload);
            this.msg.respond(payload);
        }
    }
    isWIP(p) {
        return p.length === 4 && p[0] === WPI[0] && p[1] === WPI[1] &&
            p[2] === WPI[2] && p[3] === WPI[3];
    }
    // this has to dig into the internals as the message has access
    // to the protocol but not the high-level client.
    ackAck() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.didAck) {
                this.didAck = true;
                if (this.msg.reply) {
                    const mi = this.msg;
                    const proto = mi.publisher;
                    const r = new request_1.Request(proto.muxSubscriptions);
                    proto.request(r);
                    try {
                        proto.publish(this.msg.reply, exports.ACK, {
                            reply: `${proto.muxSubscriptions.baseInbox}${r.token}`,
                        });
                    }
                    catch (err) {
                        r.cancel(err);
                    }
                    try {
                        yield Promise.race([r.timer, r.deferred]);
                        return true;
                    }
                    catch (err) {
                        r.cancel(err);
                    }
                }
            }
            return false;
        });
    }
    ack() {
        this.doAck(exports.ACK);
    }
    nak(millis) {
        let payload = NAK;
        if (millis) {
            payload = (0, codec_1.StringCodec)().encode(`-NAK ${JSON.stringify({ delay: (0, jsutil_1.nanos)(millis) })}`);
        }
        this.doAck(payload);
    }
    working() {
        this.doAck(WPI);
    }
    next(subj, ro) {
        let payload = NXT;
        if (ro) {
            const data = (0, codec_1.JSONCodec)().encode(ro);
            payload = databuffer_1.DataBuffer.concat(NXT, SPACE, data);
        }
        const opts = subj ? { reply: subj } : undefined;
        this.msg.respond(payload, opts);
    }
    term() {
        this.doAck(TERM);
    }
}
exports.JsMsgImpl = JsMsgImpl;
//# sourceMappingURL=jsmsg.js.map