"use strict";
/*
 * Copyright 2021 The NATS Authors
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoredMsgImpl = exports.StreamAPIImpl = void 0;
const types_1 = require("./types");
const jsbaseclient_api_1 = require("./jsbaseclient_api");
const jslister_1 = require("./jslister");
const jsutil_1 = require("./jsutil");
const headers_1 = require("./headers");
class StreamAPIImpl extends jsbaseclient_api_1.BaseApiClient {
    constructor(nc, opts) {
        super(nc, opts);
    }
    add(cfg = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            (0, jsutil_1.validateStreamName)(cfg.name);
            const r = yield this._request(`${this.prefix}.STREAM.CREATE.${cfg.name}`, cfg);
            const si = r;
            this._fixInfo(si);
            return si;
        });
    }
    delete(stream) {
        return __awaiter(this, void 0, void 0, function* () {
            (0, jsutil_1.validateStreamName)(stream);
            const r = yield this._request(`${this.prefix}.STREAM.DELETE.${stream}`);
            const cr = r;
            return cr.success;
        });
    }
    update(name, cfg = {}) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof name === "object") {
                const sc = name;
                name = sc.name;
                cfg = sc;
                console.trace(`\u001B[33m >> streams.update(config: StreamConfig) api changed to streams.update(name: string, config: StreamUpdateConfig) - this shim will be removed - update your code.  \u001B[0m`);
            }
            (0, jsutil_1.validateStreamName)(name);
            const ncfg = cfg;
            ncfg.name = name;
            const r = yield this._request(`${this.prefix}.STREAM.UPDATE.${name}`, ncfg);
            const si = r;
            this._fixInfo(si);
            return si;
        });
    }
    info(name, data) {
        return __awaiter(this, void 0, void 0, function* () {
            (0, jsutil_1.validateStreamName)(name);
            const r = yield this._request(`${this.prefix}.STREAM.INFO.${name}`, data);
            const si = r;
            this._fixInfo(si);
            return si;
        });
    }
    list() {
        const filter = (v) => {
            const slr = v;
            slr.streams.forEach((si) => {
                this._fixInfo(si);
            });
            return slr.streams;
        };
        const subj = `${this.prefix}.STREAM.LIST`;
        return new jslister_1.ListerImpl(subj, filter, this);
    }
    // FIXME: init of sealed, deny_delete, deny_purge shouldn't be necessary
    //  https://github.com/nats-io/nats-server/issues/2633
    _fixInfo(si) {
        si.config.sealed = si.config.sealed || false;
        si.config.deny_delete = si.config.deny_delete || false;
        si.config.deny_purge = si.config.deny_purge || false;
        si.config.allow_rollup_hdrs = si.config.allow_rollup_hdrs || false;
    }
    purge(name, opts) {
        return __awaiter(this, void 0, void 0, function* () {
            if (opts) {
                const { keep, seq } = opts;
                if (typeof keep === "number" && typeof seq === "number") {
                    throw new Error("can specify one of keep or seq");
                }
            }
            (0, jsutil_1.validateStreamName)(name);
            const v = yield this._request(`${this.prefix}.STREAM.PURGE.${name}`, opts);
            return v;
        });
    }
    deleteMessage(stream, seq, erase = true) {
        return __awaiter(this, void 0, void 0, function* () {
            (0, jsutil_1.validateStreamName)(stream);
            const dr = { seq };
            if (!erase) {
                dr.no_erase = true;
            }
            const r = yield this._request(`${this.prefix}.STREAM.MSG.DELETE.${stream}`, dr);
            const cr = r;
            return cr.success;
        });
    }
    getMessage(stream, query) {
        return __awaiter(this, void 0, void 0, function* () {
            (0, jsutil_1.validateStreamName)(stream);
            const r = yield this._request(`${this.prefix}.STREAM.MSG.GET.${stream}`, query);
            const sm = r;
            return new StoredMsgImpl(sm);
        });
    }
    find(subject) {
        return this.findStream(subject);
    }
}
exports.StreamAPIImpl = StreamAPIImpl;
class StoredMsgImpl {
    constructor(smr) {
        this.subject = smr.message.subject;
        this.seq = smr.message.seq;
        this.time = new Date(smr.message.time);
        this.data = smr.message.data ? this._parse(smr.message.data) : types_1.Empty;
        if (smr.message.hdrs) {
            const hd = this._parse(smr.message.hdrs);
            this.header = headers_1.MsgHdrsImpl.decode(hd);
        }
        else {
            this.header = (0, headers_1.headers)();
        }
    }
    _parse(s) {
        const bs = atob(s);
        const len = bs.length;
        const bytes = new Uint8Array(len);
        for (let i = 0; i < len; i++) {
            bytes[i] = bs.charCodeAt(i);
        }
        return bytes;
    }
}
exports.StoredMsgImpl = StoredMsgImpl;
//# sourceMappingURL=jsmstream_api.js.map